#                                                         -*- Perl -*-
# Copyright (c) 1999, 2000, 2001  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# ƥȤ᤿ե륯饹 (FreePWING::Text, 
# FreePWING::Heading) Τδ첾ۥ饹
#
package FreePWING::BaseText;

require 5.005;
require Exporter;
use English;
use FileHandle;
use FreePWING::Reference;
use FreePWING::Tag;
use FreePWING::RefUserChar;
use FreePWING::RefSound;
use FreePWING::CharConv;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK
	    $block_length
	    $max_indent_level);

@ISA = qw(Exporter);

#
# ֥åĹ (Хȿ)
#
$block_length = 2048;

#
# ٥
#
$max_indent_level = 6;

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    my $new = {
	# ʸեΥϥɥ
	'handle' => FileHandle->new(),

	# ʸե̾
	'file_name' => '',

	# ƥȿ
	'context_count' => 0,

	# new_context() ̵뤹뤫ɤ
	'new_context_skip_flag' => 1,
	
	# ߤΥƥȤФƽ񤭹ȥ
	'entry_count' => 0,

	# ޤǤ˽񤭹ȥ
	'total_entry_count' => 0,

	# new_entry() ̵뤹뤫ɤ
	'new_entry_skip_flag' => 1,
	
	# ߤΥեΥեå (ޤǤ˽񤭹Хȿ)
	'position' => 0,

	# ߤΥƥȤγϰ֤Υեå
	'context_position' => 0,

	# ߤΥȥγϰ֤Υեå
	'entry_position' => 0,

	# Ⱦ
	'reference' => FreePWING::Reference->new(),

	# 
	'tag' => FreePWING::Tag->new(),

	# ߤΥȥν浭һҤҾ
	'modifier_stack' => [],

	# Ⱦѳ
	'half_user_characters' => FreePWING::RefUserChar->new(),

	# ѳ
	'full_user_characters' => FreePWING::RefUserChar->new(),

	#  (satomii)
	'sounds' => FreePWING::RefSound->new(),

	# 顼å
	'error_message' => '',
    };
    return bless($new, $type);
}

#
# :
#	open(file_name, [reference_file_name, [tag_file_name]])
#           file_name
#		ƥȥե̾
#           reference_file_name
#		Ⱦե̾
#           tag_file_name
#		ե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	񤭹ѤΥƥȥե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    my ($file_name, $reference_file_name, $tag_file_name) = @ARG;

    #
    # ƥȥե򳫤
    #
    $self->{'file_name'} = $file_name;
    if (!$self->{'handle'}->open($self->{'file_name'}, 'w')) {
	$self->{'error_message'} =
	    "failed to open the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }
    binmode($self->{'handle'});

    #
    # Ⱦե򳫤
    #
    if (defined($reference_file_name)
	&& !$self->{'reference'}->open($reference_file_name)) {
	$self->{'error_message'} = $self->{'reference'}->error_message();
	$self->close_internal();
        return 0;
    }

    #
    # ե򳫤
    #
    if (defined($tag_file_name)
	&& !$self->{'tag'}->open($tag_file_name)) {
	$self->{'error_message'} = $self->{'tag'}->error_message();
	$self->close_internal();
        return 0;
    }

    #
    # 餫ῷƥȤ򳫻ϤƤ
    #
    if (!$self->new_context_internal()) {
    	return 0;
    }

    return 1;
}

#
# :
#	close()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	֥ȤƤƥȥե뷲Ĥ롣
#	ƥȥե򳫤Ƥʤϡ⤷ʤ
# :
#	 1 ֤Ԥ 0 ֤
#
sub close {
    my $self = shift;

    if (!$self->{'handle'}->fileno()) {
	return 1;
    }

    #
    # ľΥȥȥƥȤü롣
    #
    if (!$self->add_entry_end()) {
	return 0;
    }
    if (!$self->add_context_end()) {
	return 0;
    }

    #
    # Ⱦüʥ֥åθ "\0" 롣
    #
    my $pad_length = $block_length - $self->{'handle'}->tell() % $block_length;
    if ($pad_length < $block_length
	&& !$self->write_data("\0" x $pad_length)) {
	return 0;
    }
	
    #
    # եĤ롣
    #
    $self->close_internal();

    return 1;
}

#
# :
#	close_internal()
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
#       close() ѥ᥽åɡ
#
sub close_internal {
    my $self = shift;

    if ($self->{'handle'}->fileno()) {
	$self->{'handle'}->close();
    }
    $self->{'reference'}->close_internal();
    $self->{'tag'}->close_internal();
}

#
# :
#	set_half_user_characters_in_file(file_name)
#           file_name
#		ѳե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ⱦѳեɤ߹ࡣ
# :
#	 1 ֤Ԥ 0 ֤
#
sub set_half_user_characters_in_file {
    my $self = shift;
    my ($file_name) = @ARG;

    if (!$self->{'half_user_characters'}
	->add_characters_in_file($file_name)) {
	$self->{'error_message'} =
	    $self->{'half_user_characters'}->error_message();
	$self->close_internal();
        return 0;
    }

    return 1;
}

#
# :
#	set_full_user_characters_in_file(file_name)
#           file_name
#		ѳե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ⱦѳեɤ߹ࡣ
# :
#	 1 ֤Ԥ 0 ֤
#
sub set_full_user_characters_in_file {
    my $self = shift;
    my ($file_name) = @ARG;

    if (!$self->{'full_user_characters'}
	->add_characters_in_file($file_name)) {
	$self->{'error_message'} =
	    $self->{'full_user_characters'}->error_message();
	$self->close_internal();
        return 0;
    }

    return 1;
}

#
# :
#	set_sounds_in_file(file_name)
#           file_name
#		ե̾
# ᥽åɤζʬ:
#	public 󥹥󥹥᥽åɡ
# :
#	եɤ߹ࡣ
# :
#	 1 ֤Ԥ 0 ֤
#
# (satomii)
#
sub set_sounds_in_file {
    my $self = shift;
    my ($file_name) = @ARG;

    if (!$self->{'sounds'}->add_sounds_in_file($file_name)) {
	$self->{'error_message'} = $self->{'sounds'}->error_message();
	$self->close_internal();
	return 0;
    }
    return 1;
}

#
# :
#	write_data(data)
#	    data
#		񤭹ǡ (ʸ)
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
# 	Ϳ줿ǡºݤ˥ե˽񤭹ࡣ
# :
#	 1 ֤Ԥ 0 ֤
#
sub write_data {
    my $self = shift;
    my ($data) = @ARG;

    if (!$self->{'handle'}->print($data)) {
	$self->{'error_message'} =
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }

    $self->{'position'} += length($data);
}

#
# :
#	new_context()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ʥƥȤγϤؼ롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub new_context {
    my $self = shift;
    
    #
    # ǽΥƥȤФơŪ new_context() Ƥ
    # ȤϤ֤롣
    #
    if (!$self->{'new_entry_skip_flag'}) {
	$self->{'new_context_skip_flag'} = 0;
    }
    if ($self->{'new_context_skip_flag'}) {
	$self->{'new_context_skip_flag'} = 0;
	return 1;
    }
    if (!$self->new_context_internal()) {
	return 0;
    }
    return 1;
}

#
# :
#	new_context_internal()
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
# 	ʥȥγϤؼ롣
# 	new_context() μΡ
# :
#	 1 ֤Ԥ 0 ֤
#
sub new_context_internal {
    my $self = shift;

    #
    # ľΥȥȥƥȤνü񤭹ࡣ
    #
    if (0 < $self->{'entry_count'} && !$self->add_entry_end()) {
	return 0;
    }
    if (0 < $self->{'context_count'} && !$self->add_context_end()) {
	return 0;
    }

    $self->{'entry_count'} = 0;
    $self->{'new_entry_count'} = 0;
    $self->{'new_entry_skip_flag'} = 1;
    $self->{'context_count'}++;

    #
    # ʥƥȤγϵ񤭹ߡ餫ῷȥ
    # 򳫻ϤƤ
    #
    if (!$self->add_context_start()) {
	return 0;
    }
    $self->{'context_position'} = $self->{'position'};
    if (!$self->new_entry_internal()) {
    	return 0;
    }

    return 1;
}

#
# :
#	add_context_start()
# ᥽åɤζʬ:
# 	protected 󥹥󥹥᥽åɡ
# :
# 	ʥƥȤγϤ򼨤浭һҤɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_context_start {
    my $self = shift;

    if (!$self->write_data(pack('n', 0x1f02))) {
	return 0;
    }
    return 1;
}

#
# :
#	add_context_end()
# ᥽åɤζʬ:
# 	protected 󥹥󥹥᥽åɡ
# :
# 	ߤΥƥȤνü򼨤浭һҤɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_context_end {
    my $self = shift;
    
    if ($self->{'modifier_stack'}->[-1] eq 'half-width'
	&& !$self->add_half_width_end()) {
	return 0;
    }
    if (!$self->write_data(pack('n', 0x1f03))) {
	return 0;
    }
    return 1;
}

#
# :
#	new_entry()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ʥȥγϤؼ롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub new_entry {
    my $self = shift;
    
    #
    # ǽΥȥФơŪ new_entry() ƤȤ
    # ֤롣
    #
    if ($self->{'new_entry_skip_flag'}) {
	$self->{'new_entry_skip_flag'} = 0;
	return 1;
    }
    if (!$self->new_entry_internal()) {
	return 0;
    }
    return 1;
}

#
# :
#	new_entry_internal()
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
# 	ʥȥγϤؼ롣
# 	new_entry() μΡ
# :
#	 1 ֤Ԥ 0 ֤
#
sub new_entry_internal {
    my $self = shift;

    #
    # ľΥȥνü񤭹ࡣ
    #
    if (0 < $self->{'entry_count'} && !$self->add_entry_end()) {
	return 0;
    }

    $self->{'entry_position'} = $self->{'position'};

    #
    # ȥγϵ񤭹ࡣ
    #
    if (!$self->add_entry_start()) {
	return 0;
    }

    $self->{'entry_count'}++;
    $self->{'total_entry_count'}++;
    return 1;
}

#
# :
#	add_entry_start()
# ᥽åɤζʬ:
# 	protected 󥹥󥹥᥽åɡ
# :
# 	ʥȥγϤ򼨤浭һҤɲä롣
#       (Ѿ饹Ǿ񤭤뤿Υ᥽å)
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_entry_start {
    return 1;
}

#
# :
#	add_entry_end()
# ᥽åɤζʬ:
# 	protected 󥹥󥹥᥽åɡ
# :
# 	ߤΥȥνü򼨤浭һҤɲä롣
#       (Ѿ饹Ǿ񤭤뤿Υ᥽å)
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_entry_end {
    my $self = shift;
    
    if ($self->{'modifier_stack'}->[-1] eq 'half-width'
	&& !$self->add_half_width_end()) {
	return 0;
    }
    if (0 < @{$self->{'modifier_stack'}}) {
	$self->{'error_message'} =
	    "modifier not teminated before end of entry";
	$self->close_internal();
	return 0;
    }
    return 1;
}

#
# :
#	add_text(text)
#	    text
#		ƥȤʸ
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ϳ줿ǡƥȥեɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_text {
    my $self = shift;
    my ($text) = @ARG;

    #
    #  ("\r", "\n") ̵롣
    #
    $text =~ s/[\r\n]//g;
    #
    # ʿ ("\t") ϡޤѴ
    # 
    $text =~ s/\t/ /g;

    my $word;
    for (;;) {
	if ($text =~ s/^([\x20-\x7f]+)//) {
	    #
	    # US-ASCII ȾѰ
	    #
	    $word = $1;
	    if ($self->{'modifier_stack'}->[-1] ne 'half-width'
		&& !$self->add_half_width_start()) {
		return 0;
	    }
	    $word =~ s/(.)/$ascii_to_jisx0208_table->[unpack("C",$1)-0x20]/g;
	    if (!$self->write_data($word)) {
		return 0;
	    }
	} elsif ($text =~ s/^(([\xa1-\xfe]{2})+)//) {
	    #
	    # JIS X 0208 ʸϤΤޤ޵Ͽ
	    #
	    $word = $1;
	    if ($self->{'modifier_stack'}->[-1] eq 'half-width'
		&& !$self->add_half_width_end()) {
		return 0;
	    }
	    $word =~ tr/\xa1-\xfe/\x21-\x7e/;
	    if (!$self->write_data($word)) {
		return 0;
	    }
	} elsif ($text =~ s/^((\x8e[\xa1-\xfe])+)//) {
	    #
	    # SS2 Ѥ JIS X 0201 ʤ JIS X 0208 ʤѴ
	    #
	    $word = $1;
	    if ($self->{'modifier_stack'}->[-1] eq 'half-width'
		&& !$self->add_half_width_end()) {
		return 0;
	    }
	    $word =~ s/\x8e(.)/$jisx0201_to_jisx0208_table->[unpack("C",$1)-0xa0]/g;
	    if (!$self->write_data($word)) {
		return 0;
	    }
	} else {
	    if(length($text)) {
		$self->{'error_message'} =
		    sprintf("invalid character: \\x%02x", unpack("C", $text));
		$self->close_internal();
		return 0;
	    } else {
		$self->{'new_entry_skip_flag'} = 0;
		return 1;
	    }
	}
    }
}

#
# :
#	add_half_user_character(character_name)
#	    character_name
#		̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ϳ줿Ⱦѳƥȥեɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_half_user_character {
    my $self = shift;
    my ($character_name) = @ARG;

    #
    # ̾ʸֹ̾ϿƤʤХ顼
    #
    my $character_number;
    $character_number
	= $self->{'half_user_characters'}->character($character_name);
    if (!defined($character_number)) {
	$self->{'error_message'} =
	    $self->{'half_user_characters'}->error_message();
	$self->close_internal();
	return 0;
    }

    #
    # ɬפ˱ȾѳϻҤ񤭹ࡣ
    #
    if ($self->{'modifier_stack'}->[-1] ne 'half-width'
	&& !$self->add_half_width_start()) {
	return 0;
    }

    #
    # ʸֹ񤭹ࡣ
    #
    if (!$self->write_data(pack('n', $character_number))) {
	return 0;
    }

    return 1;
}

#
# :
#	add_full_user_character(character_name)
#	    character_name
#		̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ϳ줿ѳƥȥեɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_full_user_character {
    my $self = shift;
    my ($character_name) = @ARG;

    #
    # ̾ʸֹ̾ϿƤʤХ顼
    #
    my $character_number;
    $character_number
	= $self->{'full_user_characters'}->character($character_name);
    if (!defined($character_number)) {
	$self->{'error_message'} =
	    $self->{'full_user_characters'}->error_message();
	$self->close_internal();
	return 0;
    }

    #
    # ɬפ˱ȾѽλҤ񤭹ࡣ
    #
    if ($self->{'modifier_stack'}->[-1] eq 'half-width'
	&& !$self->add_half_width_end()) {
	return 0;
    }

    #
    # ʸֹ񤭹ࡣ
    #
    if (!$self->write_data(pack('n', $character_number))) {
	return 0;
    }

    return 1;
}

#
# :
#	add_entry_tag(tag)
#	    tag
#		̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ߤΥȥγϰ֤˥ɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_entry_tag {
    my $self = shift;
    my ($tag) = @ARG;
 
    $tag =~ s/^/text:/;
    return $self->{'tag'}->add_entry($tag, $self->{'entry_position'});
}

#
# :
#	add_tag(tag)
#	    tag
#		̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ߤΥƥȰ֤˥ɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_tag {
    my $self = shift;
    my ($tag) = @ARG;
    
    $tag =~ s/^/text:/;
    return $self->{'tag'}->add_entry($tag, $self->{'position'});
}

######################################################################
# <浭һҤɲä᥽åɷ>
#
# :
#	᥽å̾(argument)
#	    argument
#		浭һҤΰܤϥ᥽åȤ
#		ܤʤ᥽åɤϰʤ
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	浭һҤƥȤɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#

#
# ٤Ƥ泫ϻҤ˶̤ν
#
sub add_modifier_start {
    my $self = shift;
    my ($modifier, $data) = @ARG;

    if ($modifier ne 'half-width'
	&& $self->{'modifier_stack'}->[-1] eq 'half-width'
	&& !$self->add_half_width_end()) {
	return 0;
    }
    if (grep($_ eq $modifier, @{$self->{'modifier_stack'}}) != 0) {
	$self->{'error_message'} = "duplicate $modifier modifier";
	$self->close_internal();
	return 0;
    }
    if (!$self->write_data($data)) {
	return 0;
    }

    $self->{'new_entry_skip_flag'} = 0;
    push(@{$self->{'modifier_stack'}}, $modifier);

    return 1;
}

#
# ٤Ƥ潪λҤ˶̤ν
#
sub add_modifier_end {
    my $self = shift;
    my ($modifier, $data) = @ARG;

    if ($modifier ne 'half-width'
	&& $self->{'modifier_stack'}->[-1] eq 'half-width'
	&& !$self->add_half_width_end()) {
	return 0;
    }
    if ($self->{'modifier_stack'}->[-1] ne $modifier) {
	$self->{'error_message'} = "unexpected the end of $modifier modifier";
	$self->close_internal();
	return 0;
    }
    if (!$self->write_data($data)) {
	return 0;
    }

    $self->{'new_entry_skip_flag'} = 0;
    pop(@{$self->{'modifier_stack'}});

    return 1;
}

#
# 
#
sub add_keyword_start {
    my $self = shift;

    if (!$self->add_modifier_start('keyword', pack('nn', 0x1f41, 0x0100))) {
	return 0;
    }
    return 1;
}

#
# λ
#
sub add_keyword_end {
    my $self = shift;

    if (!$self->add_modifier_end('keyword', pack('n', 0x1f61))) {
	return 0;
    }
    return 1;
}

#
# ̹ܻ
#
sub add_reference_start {
    my $self = shift;

    if (!$self->add_modifier_start('reference', pack('n', 0x1f42))) {
	return 0;
    }
    return 1;
}

#
# ܻȽλ
# ΰ֤򼨤̾ǻꡣ
#
sub add_reference_end {
    my $self = shift;
    my ($target_position) = @ARG;

    $target_position =~ s/^/text:/;
    if (!$self->add_modifier_end('reference', pack('nNn', 0x1f62, 0, 0))) {
	return 0;
    }
    if (!$self->{'reference'}
	->add_tag_entry($self->{'position'} - 6, $target_position)) {
	$self->{'error_message'} = $self->{'reference'}->error_message();
	$self->close_internal();
	return 0;
    }
    return 1;
}

#
# 顼ǻ (BMP )
# 顼̾ǻꡣ
#
sub add_color_graphic_start {
    my $self = shift;
    my ($picture_name) = @ARG;

    $picture_name =~ s/^/cgraph:/;
    if (!$self->add_modifier_start('color-graphic',
				   pack('n3N3n', 0x1f4d, 0x0009, 0x0001,
					0, 0, 0, 0))) {
	return 0;
    }
    if (!$self->{'reference'}
	->add_tag_entry($self->{'position'} - 6, $picture_name)) {
	$self->{'error_message'} = $self->{'reference'}->error_message();
	$self->close_internal();
	return 0;
    }
    return 1;
}

#
# 顼ǻ (JPG )
# 顼̾ǻꡣ
#
sub add_jpeg_graphic_start {
    my $self = shift;
    my ($picture_name) = @ARG;

    $picture_name =~ s/^/cgraph:/;
    if (!$self->add_modifier_start('color-graphic',
				   pack('n3N3n', 0x1f4d, 0x1209, 0x0001,
					0, 0, 0, 0))) {
	return 0;
    }

    if (!$self->{'reference'}
	->add_tag_entry($self->{'position'} - 6, $picture_name)) {
	$self->{'error_message'} = $self->{'reference'}->error_message();
	$self->close_internal();
	return 0;
    }
    return 1;
}

#
# 顼ǻȽλ (BMP )
#
sub add_color_graphic_end {
    my $self = shift;

    if (!$self->add_modifier_end('color-graphic', pack('n', 0x1f6d))) {
	return 0;
    }
    return 1;
}

#
# 顼ǻȽλ (JPG )
#
sub add_jpeg_graphic_end {
    my $self = shift;

    if (!$self->add_modifier_end('color-graphic', pack('n', 0x1f6d))) {
	return 0;
    }
    return 1;
}

#
# 
# ǡ̾ǻꡣ
#
sub add_sound_start {
    my $self = shift;
    my ($sound_name) = @ARG;

    #  FreePWING::RefSound ͳǼ롣(satomii)
    if (!$self->add_modifier_start(
	     'sound',
	     pack('nC2nNnNn', 0x1f4a, 0,
		  $self->{'sounds'}->sound_type($sound_name),
		  $self->{'sounds'}->sound_format($sound_name),
		  0, 0, 0, 0))) {
	return 0;
    }

    # if (!$self->add_modifier_start('sound',
    #				   pack('n3N3', 0x1f4a, 0, 0x0012, 0, 0, 0))) {
    #	return 0;
    # }
    if (!$self->{'reference'}
	->add_tag_entry($self->{'position'} - 12, "sound:$sound_name")) {
	$self->{'error_message'} = $self->{'reference'}->error_message();
	$self->close_internal();
	return 0;
    }
    if (!$self->{'reference'}
	->add_tag_entry($self->{'position'} - 6, "sound-end:$sound_name")) {
	$self->{'error_message'} = $self->{'reference'}->error_message();
	$self->close_internal();
	return 0;
    }
    return 1;
}

#
# Ƚλ
# ΰ֤򼨤̾ǻꡣ
#
sub add_sound_end {
    my $self = shift;

    if (!$self->add_modifier_end('sound', pack('n', 0x1f6a))) {
	return 0;
    }
    return 1;
}

#
# Ⱦѳϻ
#
sub add_half_width_start {
    my $self = shift;

    if (!$self->add_modifier_start('half-width', pack('n', 0x1f04))) {
	return 0;
    }
    return 1;
}

#
# Ⱦѽλ
#
sub add_half_width_end {
    my $self = shift;

    if (!$self->add_modifier_end('half-width', pack('n', 0x1f05))) {
	return 0;
    }
    return 1;
}

#
# źϻ
#
sub add_subscript_start {
    my $self = shift;

    if (!$self->add_modifier_start('subscript', pack('n', 0x1f06))) {
	return 0;
    }
    return 1;
}

#
# źλ
#
sub add_subscript_end {
    my $self = shift;

    if (!$self->add_modifier_end('subscript', pack('n', 0x1f07))) {
	return 0;
    }
    return 1;
}

#
# 
#  (2  $max_indent_level) ǻꡣ
#
sub add_indent_level {
    my $self = shift;
    my ($level) = @ARG;

    if ($level < 2 || $max_indent_level < $level) {
	$self->{'error_message'} = "invalid indent level: $level";
	$self->close_internal();
	return 0;
    }
    if (!$self->write_data(pack('nn', 0x1f09, $level))) {
	return 0;
    }
    $self->{'new_entry_skip_flag'} = 0;
    return 1;
}

#
# 
#
sub add_newline {
    my $self = shift;

    if ($self->{'modifier_stack'}->[-1] eq 'half-width'
	&& !$self->add_half_width_end()) {
	return 0;
    }
    if (0 < @{$self->{'modifier_stack'}}) {
	$self->{'error_message'} = "modifier not teminated before newline";
	$self->close_internal();
	return 0;
    }
    if (!$self->write_data(pack('n', 0x1f0a))) {
	return 0;
    }
    $self->{'new_entry_skip_flag'} = 0;
    return 1;
}

#
# źϻ
#
sub add_superscript_start {
    my $self = shift;

    if (!$self->add_modifier_start('superscript', pack('n', 0x1f0e))) {
	return 0;
    }
    return 1;
}

#
# źλ
#
sub add_superscript_end {
    my $self = shift;

    if (!$self->add_modifier_end('superscript', pack('n', 0x1f0f))) {
	return 0;
    }
    return 1;
}

#
# ʬػ߳ϻ
#
sub add_nowrap_start {
    my $self = shift;

    if (!$self->add_modifier_start('nowrap', pack('n', 0x1f10))) {
	return 0;
    }
    return 1;
}

#
# ʬػ߽λ
#
sub add_nowrap_end {
    my $self = shift;

    if (!$self->add_modifier_end('nowrap', pack('n', 0x1f11))) {
	return 0;
    }
    return 1;
}

#
# Ĵϻ
#
sub add_emphasis_start {
    my $self = shift;

    if (!$self->add_modifier_start('emphasis', pack('n', 0x1f12))) {
	return 0;
    }
    return 1;
}

#
# Ĵλ
#
sub add_emphasis_end {
    my $self = shift;

    if (!$self->add_modifier_end('emphasis', pack('n', 0x1f13))) {
	return 0;
    }
    return 1;
}

#
# ̥եȳϻ
#
sub add_font_start {
    my $self = shift;
    my ($font_name) = @ARG;
    my $parameter;

    if ($font_name eq 'italic') {
	$parameter = 1;
    } elsif ($font_name eq 'bold') {
	$parameter = 3;
    } else {
	$self->{'error_message'} = "unknown font name $font_name";
	$self->close_internal();
	return 0;
    }
    if (!$self->add_modifier_start('font', pack('nn', 0x1fe0, $parameter))) {
	return 0;
    }
    return 1;
}

#
# ̥եȽλ
#
sub add_font_end {
    my $self = shift;

    if (!$self->add_modifier_end('font', pack('n', 0x1fe1))) {
	return 0;
    }
    return 1;
}

######################################################################
# <󥹥ѿ֤ͤ᥽åɷ>
#
# :
#	󥹥ѿ̾()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
#	󥹥ѿ֤ͤ
#
sub file_name {
    my $self = shift;
    return $self->{'file_name'};
}

sub reference_file_name {
    my $self = shift;
    return $self->{'reference'}->file_name();
}

sub tag_file_name {
    my $self = shift;
    return $self->{'tag'}->file_name();
}

sub half_user_character {
    my $self = shift;
    my ($name) = @ARG;
    return $self->{'half_user_characters'}->character($name);
}

sub full_user_character {
    my $self = shift;
    my ($name) = @ARG;
    return $self->{'full_user_characters'}->character($name);
}

sub context_position {
    my $self = shift;
    return $self->{'context_position'};
}

sub entry_position {
    my $self = shift;
    return $self->{'entry_position'};
}

sub context_count {
    my $self = shift;
    return $self->{'context_count'};
}

sub entry_count {
    my $self = shift;
    return $self->{'entry_count'};
}

sub total_entry_count {
    my $self = shift;
    return $self->{'total_entry_count'};
}

sub error_message {
    my $self = shift;
    return $self->{'error_message'};
}

1;
