;;; -*- lexical-binding: t -*-
(defun lookup-makeinfo (info)
  (let ((texi (concat (file-name-sans-extension info) ".texi")))
    (save-current-buffer
      (let ((buf (find-file-noselect 
		  (expand-file-name texi ".") t))
	    beg end)
	(set-buffer buf)
	(condition-case nil
	    (texinfo-format-buffer)
	  (error
	   ;; one more try with no @direntry
	   ;; (kill-buffer (current-buffer))
	   (set-buffer buf)
	   (goto-char (point-min))
	   (message "Format failed. Trying no @direntry")
	   (when (re-search-forward "@documentlanguage .*$" nil t)
	     (replace-match "" t t))
	   (goto-char (point-min))
	   (when (re-search-forward "@direntry" nil t)
	     (setq beg (match-beginning 0))
	     (when (re-search-forward "@end direntry" nil t)
	       (delete-region beg (match-end 0))))
	   (goto-char (point-min))
	   (when (re-search-forward "@dircategory" nil t)
	     (setq end (progn(end-of-line)(point)))
	     (delete-region (match-beginning 0) end))
	   (when (re-search-forward "@detailmenu" nil t)
	     (beginning-of-line)
	     (insert "@c")
	     (when (re-search-forward "@end detailmenu" nil t)
	       (beginning-of-line)
	       (insert "@c")))
	   (goto-char (point-min))
	   (while (re-search-forward "@ifnottex" nil t)
	     (replace-match "@ifinfo" t t))
	   (goto-char (point-min))
	   (while (re-search-forward "@end ifnottex" nil t)
	     (replace-match "@end ifinfo" t t))
	   (goto-char (point-min))
	   (while (re-search-forward  
		   "@\\(email\\|url\\){\\([^}]+\\)}" nil t)
	     (replace-match 
	      (buffer-substring (match-beginning 2) (match-end 2))))
	   (texinfo-format-buffer)))
	(let ((coding-system-for-write 'iso-2022-jp-unix))
	  (save-buffer 0))
	(kill-buffer)
	(kill-buffer buf)))))
