;;; lookup-text-table.el --- tables for lookup-text.el -*- coding: utf-8; lexical-binding: t -*-
;; Copyright (C) 2009 Kazuhiro Ito

;; Author: Kazuhiro Ito <kzhr@d1.dion.ne.jp>
;; Version: $Id$

;; This file is part of Lookup.

;; Lookup is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; Lookup is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with Lookup; if not, write to the Free Software Foundation,
;; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;;; Commentary:

;;; Code:

(defconst lookup-text-new-old-alist
  '((?万 . ?萬) (?与 . ?與) (?両 . ?兩) (?並 . ?竝) (?乗 . ?乘)
    (?乱 . ?亂) (?予 . ?豫) (?争 . ?爭) (?亜 . ?亞) (?仏 . ?佛)
    (?仮 . ?假) (?会 . ?會) (?伝 . ?傳) (?体 . ?體) (?余 . ?餘)
    (?併 . ?倂) (?価 . ?價) (?侮 . ?侮) (?倹 . ?儉) (?偽 . ?僞)
    (?僧 . ?僧) (?免 . ?免) (?児 . ?兒) (?党 . ?黨) (?円 . ?圓)
    (?写 . ?寫) (?処 . ?處) (?剣 . ?劍) (?剤 . ?劑) (?剰 . ?剩)
    (?励 . ?勵) (?労 . ?勞) (?効 . ?效) (?勅 . ?敕) (?勉 . ?勉)
    (?勤 . ?勤) (?勧 . ?勸) (?勲 . ?勳) (?区 . ?區) (?医 . ?醫)
    (?卑 . ?卑) (?単 . ?單) (?即 . ?卽) (?厳 . ?嚴) (?参 . ?參)
    (?双 . ?雙) (?収 . ?收) (?叙 . ?敍) (?台 . ?臺) (?号 . ?號)
    (?喝 . ?喝) (?営 . ?營) (?嘆 . ?嘆) (?嘱 . ?囑) (?器 . ?器)
    (?団 . ?團) (?囲 . ?圍) (?図 . ?圖) (?国 . ?國) (?圏 . ?圈)
    (?圧 . ?壓) (?堕 . ?墮) (?塀 . ?塀) (?塁 . ?壘) (?塚 . ?塚)
    (?塩 . ?鹽) (?増 . ?增) (?墨 . ?墨) (?壊 . ?壞) (?壌 . ?壤)
    (?壮 . ?壯) (?声 . ?聲) (?壱 . ?壹) (?売 . ?賣) (?変 . ?變)
    (?奥 . ?奧) (?奨 . ?奬) (?嬢 . ?孃) (?学 . ?學) (?宝 . ?寶)
    (?実 . ?實) (?寛 . ?寬) (?寝 . ?寢) (?対 . ?對) (?寿 . ?壽)
    (?専 . ?專) (?将 . ?將) (?尽 . ?盡) (?届 . ?屆) (?属 . ?屬)
    (?層 . ?層) (?岳 . ?嶽) (?峡 . ?峽) (?巣 . ?巢) (?巻 . ?卷)
    (?帯 . ?帶) (?帰 . ?歸) (?庁 . ?廳) (?広 . ?廣) (?廃 . ?廢)
    (?廊 . ?廊) (?弁 . ?弁) (?弁 . ?瓣) (?弁 . ?辯) (?弁 . ?辨)
    (?弐 . ?貳) (?弾 . ?彈) (?当 . ?當) (?径 . ?徑) (?従 . ?從)
    (?徳 . ?德) (?徴 . ?徵) (?応 . ?應) (?恋 . ?戀) (?恒 . ?恆)
    (?恵 . ?惠) (?悔 . ?悔) (?悩 . ?惱) (?悪 . ?惡) (?惨 . ?慘)
    (?慎 . ?愼) (?慨 . ?慨) (?憎 . ?憎) (?懐 . ?懷) (?懲 . ?懲)
    (?戦 . ?戰) (?戯 . ?戲) (?戻 . ?戾) (?払 . ?拂) (?抜 . ?拔)
    (?択 . ?擇) (?担 . ?擔) (?拝 . ?拜) (?拠 . ?據) (?拡 . ?擴)
    (?挙 . ?擧) (?挟 . ?挾) (?挿 . ?插) (?捜 . ?搜) (?掲 . ?揭)
    (?揺 . ?搖) (?摂 . ?攝) (?撃 . ?擊) (?敏 . ?敏) (?数 . ?數)
    (?斉 . ?齊) (?斎 . ?齋) (?断 . ?斷) (?既 . ?既) (?旧 . ?舊)
    (?昼 . ?晝) (?晩 . ?晚) (?暁 . ?曉) (?暑 . ?暑) (?暦 . ?曆)
    (?朗 . ?朗) (?条 . ?條) (?来 . ?來) (?枢 . ?樞) (?栄 . ?榮)
    (?桜 . ?櫻) (?桟 . ?棧) (?梅 . ?梅) (?検 . ?檢) (?楼 . ?樓)
    (?楽 . ?樂) (?概 . ?槪) (?様 . ?樣) (?権 . ?權) (?横 . ?橫)
    (?欄 . ?欄) (?欠 . ?缺) (?欧 . ?歐) (?歓 . ?歡) (?歩 . ?步)
    (?歯 . ?齒) (?歴 . ?歷) (?残 . ?殘) (?殴 . ?毆) (?殺 . ?殺)
    (?殻 . ?殼) (?毎 . ?每) (?気 . ?氣) (?沢 . ?澤) (?浄 . ?淨)
    (?浅 . ?淺) (?浜 . ?濱) (?海 . ?海) (?涙 . ?淚) (?渇 . ?渴)
    (?済 . ?濟) (?渉 . ?涉) (?渋 . ?澁) (?渓 . ?溪) (?温 . ?溫)
    (?湾 . ?灣) (?湿 . ?濕) (?満 . ?滿) (?滝 . ?瀧) (?滞 . ?滯)
    (?漢 . ?漢) (?潜 . ?潛) (?瀬 . ?瀨) (?灯 . ?燈) (?炉 . ?爐)
    (?点 . ?點) (?為 . ?爲) (?焼 . ?燒) (?煮 . ?煮) (?犠 . ?犧)
    (?状 . ?狀) (?独 . ?獨) (?狭 . ?狹) (?猟 . ?獵) (?献 . ?獻)
    (?獣 . ?獸) (?瓶 . ?甁) (?画 . ?畫) (?畳 . ?疊) (?痴 . ?癡)
    (?発 . ?發) (?盗 . ?盜) (?県 . ?縣) (?真 . ?眞) (?研 . ?硏)
    (?砕 . ?碎) (?碑 . ?碑) (?礼 . ?禮) (?社 . ?社) (?祈 . ?祈)
    (?祉 . ?祉) (?祖 . ?祖) (?祝 . ?祝) (?神 . ?神) (?祥 . ?祥)
    (?禅 . ?禪) (?禍 . ?禍) (?福 . ?福) (?秘 . ?祕) (?称 . ?稱)
    (?稲 . ?稻) (?穀 . ?穀) (?穂 . ?穗) (?穏 . ?穩) (?突 . ?突)
    (?窃 . ?竊) (?竜 . ?龍) (?節 . ?節) (?粋 . ?粹) (?粛 . ?肅)
    (?糸 . ?絲) (?経 . ?經) (?絵 . ?繪) (?継 . ?繼) (?続 . ?續)
    (?総 . ?總) (?緑 . ?綠) (?緒 . ?緖) (?練 . ?練) (?縁 . ?緣)
    (?縄 . ?繩) (?縦 . ?縱) (?繁 . ?繁) (?繊 . ?纖) (?缶 . ?罐)
    (?署 . ?署) (?翻 . ?飜) (?者 . ?者) (?聴 . ?聽) (?胆 . ?膽)
    (?脳 . ?腦) (?臓 . ?臟) (?臭 . ?臭) (?芸 . ?藝) (?茎 . ?莖)
    (?荘 . ?莊) (?著 . ?著) (?蔵 . ?藏) (?薫 . ?薰) (?薬 . ?藥)
    (?虚 . ?虛) (?虜 . ?虜) (?虫 . ?蟲) (?蚕 . ?蠶) (?蛍 . ?螢)
    (?蛮 . ?蠻) (?衛 . ?衞) (?装 . ?裝) (?褐 . ?褐) (?褒 . ?襃)
    (?覇 . ?霸) (?視 . ?視) (?覚 . ?覺) (?覧 . ?覽) (?観 . ?觀)
    (?触 . ?觸) (?訳 . ?譯) (?証 . ?證) (?誉 . ?譽) (?読 . ?讀)
    (?諸 . ?諸) (?謁 . ?謁) (?謡 . ?謠) (?謹 . ?謹) (?譲 . ?讓)
    (?豊 . ?豐) (?賓 . ?賓) (?賛 . ?贊) (?贈 . ?贈) (?践 . ?踐)
    (?転 . ?轉) (?軽 . ?輕) (?辞 . ?辭) (?辺 . ?邊) (?逓 . ?遞)
    (?逸 . ?逸) (?遅 . ?遲) (?郎 . ?郞) (?郷 . ?鄕) (?都 . ?都)
    (?酔 . ?醉) (?醸 . ?釀) (?釈 . ?釋) (?鉄 . ?鐵) (?鉱 . ?鑛)
    (?銭 . ?錢) (?鋳 . ?鑄) (?錬 . ?鍊) (?録 . ?錄) (?鎮 . ?鎭)
    (?関 . ?關) (?闘 . ?鬪) (?陥 . ?陷) (?険 . ?險) (?隆 . ?隆)
    (?随 . ?隨) (?隠 . ?隱) (?雑 . ?雜) (?難 . ?難) (?霊 . ?靈)
    (?静 . ?靜) (?響 . ?響) (?頻 . ?頻) (?頼 . ?賴) (?顕 . ?顯)
    (?類 . ?類) (?駅 . ?驛) (?駆 . ?驅) (?騒 . ?騷) (?験 . ?驗)
    (?髄 . ?髓) (?髪 . ?髮) (?鶏 . ?鷄) (?麦 . ?麥) (?黄 . ?黃)
    (?黒 . ?黑) (?黙 . ?默) (?齢 . ?齡)))

(defconst lookup-text-old-new-alist
  (mapcar (lambda (elt) (cons (cdr elt) (car elt)))
	  lookup-text-new-old-alist))

(defconst lookup-latin-alphabet-accent-alist
  '((?À . ?A) (?Á . ?A) (?Â . ?A) (?Ã . ?A) (?Ä . ?A) (?Å . ?A)
    (?Ç . ?C) (?È . ?E) (?É . ?E) (?Ê . ?E) (?Ë . ?E) (?Ì . ?I)
    (?Í . ?I) (?Î . ?I) (?Ï . ?I) (?Ñ . ?N) (?Ò . ?O) (?Ó . ?O)
    (?Ô . ?O) (?Õ . ?O) (?Ö . ?O) (?Ù . ?U) (?Ú . ?U) (?Û . ?U)
    (?Ü . ?U) (?Ý . ?Y) (?à . ?a) (?á . ?a) (?â . ?a) (?ã . ?a)
    (?ä . ?a) (?å . ?a) (?ç . ?c) (?è . ?e) (?é . ?e) (?ê . ?e)
    (?ë . ?e) (?ì . ?i) (?í . ?i) (?î . ?i) (?ï . ?i) (?ñ . ?n)
    (?ò . ?o) (?ó . ?o) (?ô . ?o) (?õ . ?o) (?ö . ?o) (?ù . ?u)
    (?ú . ?u) (?û . ?u) (?ü . ?u) (?ý . ?y) (?ÿ . ?y) (?Ā . ?A)
    (?ā . ?a) (?Ă . ?A) (?ă . ?a) (?Ą . ?A) (?ą . ?a) (?Ć . ?C)
    (?ć . ?c) (?Ĉ . ?C) (?ĉ . ?c) (?Ċ . ?C) (?ċ . ?c) (?Č . ?C)
    (?č . ?c) (?Ď . ?D) (?ď . ?d) (?Ē . ?E) (?ē . ?e) (?Ė . ?E)
    (?ė . ?e) (?Ę . ?E) (?ę . ?e) (?Ě . ?E) (?ě . ?e) (?Ĝ . ?G)
    (?ĝ . ?g) (?Ğ . ?G) (?ğ . ?g) (?Ġ . ?G) (?ġ . ?g) (?Ģ . ?G)
    (?ģ . ?g) (?Ĥ . ?H) (?ĥ . ?h) (?Ĩ . ?I) (?ĩ . ?i) (?Ī . ?I)
    (?ī . ?i) (?Į . ?I) (?į . ?i) (?İ . ?I) (?ı . ?i) (?Ĵ . ?J)
    (?ĵ . ?j) (?Ķ . ?K) (?ķ . ?k) (?Ĺ . ?L) (?ĺ . ?l) (?Ļ . ?L)
    (?ļ . ?l) (?Ľ . ?L) (?ľ . ?l) (?Ŀ . ?L) (?ŀ . ?l) (?Ń . ?N)
    (?ń . ?n) (?Ņ . ?N) (?ņ . ?n) (?Ň . ?N) (?ň . ?n) (?ŉ . ?n)
    (?Ō . ?O) (?ō . ?o) (?Ő . ?O) (?ő . ?o) (?Ŕ . ?R) (?ŕ . ?r)
    (?Ŗ . ?R) (?ŗ . ?r) (?Ř . ?R) (?ř . ?r) (?Ś . ?S) (?ś . ?s)
    (?Ŝ . ?S) (?ŝ . ?s) (?Ş . ?S) (?ş . ?s) (?Š . ?S) (?š . ?s)
    (?Ţ . ?T) (?ţ . ?t) (?Ť . ?T) (?ť . ?t) (?Ũ . ?U) (?ũ . ?u)
    (?Ū . ?U) (?ū . ?u) (?Ŭ . ?U) (?ŭ . ?u) (?Ů . ?U) (?ů . ?u)
    (?Ű . ?U) (?ű . ?u) (?Ų . ?U) (?ų . ?u) (?Ŵ . ?W) (?ŵ . ?w)
    (?Ŷ . ?Y) (?ŷ . ?y) (?Ÿ . ?Y) (?Ź . ?Z) (?ź . ?z) (?Ż . ?Z)
    (?ż . ?z) (?Ž . ?Z) (?ž . ?z) (?Ơ . ?O) (?ơ . ?O) (?Ư . ?U)
    (?ư . ?U) (?Ǎ . ?A) (?ǎ . ?a) (?Ǐ . ?I) (?ǐ . ?i) (?Ǒ . ?O)
    (?ǒ . ?o) (?Ǔ . ?U) (?ǔ . ?u) (?Ǖ . ?U) (?ǖ . ?u) (?Ǘ . ?U)
    (?ǘ . ?u) (?Ǚ . ?U) (?ǚ . ?u) (?Ǜ . ?U) (?ǜ . ?u) (?ǵ . ?g)
    (?Ạ . ?A) (?ạ . ?a) (?Ả . ?A) (?ả . ?a) (?Ấ . ?A) (?ấ . ?a)
    (?Ầ . ?A) (?ầ . ?a) (?Ẩ . ?A) (?ẩ . ?a) (?Ẫ . ?A) (?ẫ . ?a)
    (?Ậ . ?A) (?ậ . ?a) (?Ắ . ?A) (?ắ . ?a) (?Ằ . ?A) (?ằ . ?a)
    (?Ẳ . ?A) (?ẳ . ?a) (?Ẵ . ?A) (?ẵ . ?a) (?Ặ . ?A) (?ặ . ?a)
    (?Ẹ . ?E) (?ẹ . ?e) (?Ẻ . ?E) (?ẻ . ?e) (?Ẽ . ?E) (?ẽ . ?e)
    (?Ế . ?E) (?ế . ?e) (?Ề . ?E) (?ề . ?e) (?Ể . ?E) (?ể . ?e)
    (?Ễ . ?E) (?ễ . ?e) (?Ệ . ?E) (?ệ . ?e) (?Ỉ . ?I) (?ỉ . ?i)
    (?Ị . ?I) (?ị . ?i) (?Ọ . ?O) (?ọ . ?o) (?Ỏ . ?O) (?ỏ . ?o)
    (?Ố . ?O) (?ố . ?o) (?Ồ . ?O) (?ồ . ?o) (?Ổ . ?O) (?ổ . ?o)
    (?Ỗ . ?O) (?ỗ . ?o) (?Ộ . ?O) (?ộ . ?o) (?Ớ . ?O) (?ớ . ?o)
    (?Ờ . ?O) (?ờ . ?o) (?Ở . ?O) (?ở . ?o) (?Ỡ . ?O) (?ỡ . ?o)
    (?Ợ . ?O) (?ợ . ?o) (?Ụ . ?U) (?ụ . ?u) (?Ủ . ?U) (?ủ . ?u)
    (?Ứ . ?U) (?ứ . ?u) (?Ừ . ?U) (?ừ . ?u) (?Ử . ?U) (?ử . ?u)
    (?Ữ . ?U) (?ữ . ?u) (?Ự . ?U) (?ự . ?u) (?Ỵ . ?Y) (?ỵ . ?y)
    (?Ỷ . ?Y) (?ỷ . ?y) (?Ỹ . ?Y) (?ỹ . ?y)))

(provide 'lookup-text-table)
