/*                                                            -*- C -*-
 * Copyright (c) 2019  Kazuhiro Ito
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "defs.h"

struct Error_Table {
  enum dzzip_error_code code;
  const char *message;
};

static struct Error_Table dzzip_error_message_table[] = {
  {DZZIP_SUCCESS, "No error."},
  {DZZIP_ERR_INVALID_INPUT_FILE, "Invalid input file."},
  {DZZIP_ERR_NOT_DICTZIP, "File is not dictzip file."},
  {DZZIP_ERR_NOT_GZIP, "File is not gizpped file."},
  {DZZIP_ERR_FILE_IO, "File I/O error"},
  {DZZIP_ERR_INVALID_BASE64, "Invalid base64 encoded string."},
  {DZZIP_ERR_TOO_LONG_STRING, "Too long string."},
  {DZZIP_ERR_ZLIB_ERROR, "zlib error occured."},
  {DZZIP_ERR_TOO_LARGE_INPUT_FILE, "Input file is too large."},
  {DZZIP_ERR_MEMORY_EXHAUSTED, "Memory exhausted."},
  {DZZIP_ERR_OUTPUT_EXISTS, "Output file is already exists."},
  {DZZIP_ERR_INVALID_INPUT_FILE_NAME, "Invalid input file name (probably does't have '.')."},
  {DZZIP_ERR_INVALID_DICTZIP, "Invalid dictzip structure."},
  {DZZIP_ERR_INVALID_START, "Invalid starting position."},
  {-1, "unknown error"},
};



const char *dzzip_error_message (enum dzzip_error_code code) {
  int i;

  for (i = 0; (dzzip_error_message_table[i]).code != -1; i++)
    if (code == (dzzip_error_message_table[i]).code) break;

  return (dzzip_error_message_table[i]).message;
}
