#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdint.h>

#include "defs.h"

extern int global_verbose;
extern int global_debug;
extern int global_stdout;

uint32_t read_uint32(unsigned char *buffer) {
  return buffer[0] + (buffer[1] << 8) + (buffer[2] << 16) + (buffer[3] << 24);
}

uint16_t read_uint16(unsigned char *buffer) {
  return buffer[0] + (buffer[1] <<  8);
}

void write_uint32(unsigned char *buffer, uint32_t n) {
  buffer[0] = n         & 255;
  buffer[1] = (n >> 8)  & 255;
  buffer[2] = (n >> 16) & 255;
  buffer[3] = (n >> 24) & 255;
}

void write_uint16(unsigned char *buffer, uint16_t n) {
  buffer[0] = n         & 255;
  buffer[1] = (n >> 8)  & 255;
}


void debug_out (const char *message, ...) {
  if (global_debug) {
    va_list ap;
    va_start(ap, message);

    fputs("[DZZIP] ", stderr);

    vfprintf(stderr, message, ap);
    fputc('\n', stderr);
    fflush(stderr);
  }
}

void verbose_out (const char *message, ...) {
  if (global_verbose || global_debug) {
    va_list ap;
    FILE *fp = global_stdout ? stderr : stdout;
    va_start(ap, message);

    vfprintf(fp, message, ap);
    fputc('\n', fp);
    fflush(fp);
  }
}

static int base64_table[256] = {
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 
  52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, 
  -1,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 
  15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, 
  -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 
  41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
};

int64_t base64_decode_string (const char *string) {
  /* This is NOT a generic base64 decoder. */
  size_t length = strlen(string);
  int64_t result = 0;
  
  for (int i = 0; i < length; i++) {
    if (base64_table[(unsigned char)string[i]] >= 0) {
      result = (result << 6) + base64_table[(unsigned char)string[i]];
    } else {
      fprintf(stderr, "Illegal base64 string.\n");
      return -1;
    }
  }

  if (result < 0) {
    fprintf(stderr, "String may be too long.\n");
  }

  return result;
}

