/*                                                            -*- C -*-
 * Copyright (c) 2008  Kazuhiro Ito
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef PDICR_INTERNAL_H
#define PDICR_INTERNAL_H

#include "../config.h"
#include "pdicr.h"
#include "defs.h"

#define pdicr_uint2(p) ((*(const unsigned char *)(p))	\
		       + (*(const unsigned char *)((p) + 1) << 8))

#define pdicr_uint4(p) ((*(const unsigned char *)(p))			\
		       + (*(const unsigned char *)((p) + 1) << 8)	\
		       + (*(const unsigned char *)((p) + 2) << 16)	\
		       + (*(const unsigned char *)((p) + 3) << 24))

/* no error check */
#define utf8_length(c) \
  (((c) < 0x80) ? 1 : (((c) < 0x800) ? 2 : (((c) < 0x10000) ? 3 : 4)))

#ifdef bocu1Prev
#undef bocu1Prev
#endif
#ifdef decodeBocu1
#undef decodeBocu1
#endif

#ifdef encodeBocu1
#undef encodeBocu1
#endif
#ifdef packDiff
#undef packDiff
#endif

#define bocu1Prev   pdicr_bocu1Prev
#define decodeBocu1 pdicr_decodeBocu1
#define encodeBocu1 pdicr_encodeBocu1
#define packDiff    pdicr_packDiff


/* cache.c */
void pdicr_caches_finalize (PDICR_Cache *caches);
PDICR_Error_Code pdicr_caches_fread 
(PDICR_Book *book, PDICR_Position pos, size_t req_size, char *buffer,
 size_t *result);

/* codeconv.c */
PDICR_Error_Code pdicr_convert_bocu1_utf8 (const char *str, char **to_s);
PDICR_Error_Code pdicr_convert_utf8_bocu1 (const char *str, char **to_s);
int pdicr_write_utf8 (int code, char *buffer);
int pdicr_read_utf8 (const char *buffer, int *code);

/* pron_table.c */
PDICR_Error_Code pdicr_convert_from_pron
(PDICR_Book *book, const char *string, char **to_s);
PDICR_Error_Code pdicr_convert_bocu1_pron
(const char *string, PDICR_Pron_Table *table, char **to_s);

#endif
