/*                                             -*- mode: C; coding: utf-8; -*-
 * Copyright (c) 2010  Kazuhiro Ito
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "pdicr_internal.h"

struct defaults_table1 {
  char id[8];
  PDICR_Pron_Table_Code pron_code;
};

/* struct defaults_table2 { */
/*   char *basename; */
/*   PDICR_Version version; */
/*   PDICR_Character_Code coding; */
/*   PDICR_Pron_Table_Code pron_code; */
/* }; */

static struct defaults_table1 table[] ={
  /* GIAPPITALIX イタリア語辞典 */
  {{0x81, 0x6e, 0x01, 0xcc, 0xe3, 0x57, 0x4f, 0xec}, PDICR_Pron_Table_Code_SILIPA93},
};
static int table_number = sizeof(table) / sizeof(struct defaults_table1);

/* static struct defaults_table2 table2[] ={ */
/*   {"pdedict",  PDICR_Version_NEWDIC3, PDICR_Coding_SJIS,  PDICR_Pron_Table_Code_ASIS}, */
/* }; */
/* static int table2_number = sizeof(table2) / sizeof(struct defaults_table2); */

/* static functions */
static PDICR_Error_Code pdicr_book_default_internal1 (PDICR_Book *book);
/* static PDICR_Error_Code pdicr_book_default_internal2 (PDICR_Book *book); */

PDICR_Error_Code pdicr_book_default (PDICR_Book *book) {
  /* PDICR_Error_Code ret; */

  if (book->version >= PDICR_Version_NEWDIC3_5) {
    /* ret = pdicr_book_default_internal1(book); */
    /* if (ret != PDICR_ERR_NO_BOOK_DEFAULT) return ret; */
    return pdicr_book_default_internal1(book);
  }
  /* return pdicr_book_default_internal2(book); */
  return PDICR_ERR_NO_BOOK_DEFAULT;
}

static PDICR_Error_Code pdicr_book_default_internal1 (PDICR_Book *book) {
  PDICR_Error_Code ret;
  int i, j;

  for (i = 0; i < table_number; i++) {
    for (j = 0; j < 8; j++)
      if (book->id[j] != table[i].id[j]) break;
    if (j == 8) {
      book->pron_table_code = table[i].pron_code;
      break;
    }
  }
  if (i == table_number) return PDICR_ERR_NO_BOOK_DEFAULT;
  return PDICR_SUCCESS;
}

/* static PDICR_Error_Code pdicr_book_default_internal2 (PDICR_Book *book) { */
/*   PDICR_Error_Code ret; */
/*   int i, j; */
/*   char *basename; */

/*   for (i=0; i < table2_number; i++) { */
/*     /\* check version *\/ */
/*     if (book->version != table2[i].version) continue; */
/*     /\* check coding *\/ */
/*     if (book->coding != table2[i].coding) continue; */
/*     /\* check matching of title *\/ */
/*     ret = pdicr_path_basename(book->path, &basename); */
/*     if (ret != PDICR_SUCCESS) return ret; */
/*     for (j = 0; basename[j]; j++) { */
/*       if (basename[j] >= 'A' && basename[j] <= 'Z') */
/* 	basename[j] += 0x20; */
/*     } */
/*     j = strcmp(basename, table2[i].basename); */
/*     pdicr_free(basename); */
/*     if (j) continue; */

/*     /\* matched entry is found *\/ */
/*     book->pron_table_code = table2[i].pron_code; */
/*     return PDICR_SUCCESS; */
/*   } */

/*   return PDICR_ERR_NO_BOOK_DEFAULT; */
/* } */
