/*                                                            -*- C -*-
 * Copyright (c) 2010  Kazuhiro Ito
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef PDICR_H
#define PDICR_H

#include "defs.h"

#include <stdio.h>
#include <stdlib.h>

/* error.c */
char *pdicr_error_message (PDICR_Error_Code code);

/* defaults.c */
PDICR_Error_Code pdicr_book_default (PDICR_Book *book);

/* codeconv.c */
PDICR_Error_Code pdicr_convert_to_utf8
(PDICR_Book *book, const char *string, size_t length, char **to_string);

/* common.c */
PDICR_Error_Code pdicr_malloc (size_t size, char **buffer);
PDICR_Error_Code pdicr_realloc (size_t size, char **buffer);
void pdicr_free(char *buffer);
int pdicr_remove_cr (char *string);
PDICR_Error_Code pdicr_strdup (const char *string, char **to_s);
PDICR_Error_Code pdicr_heading_key (const char *heading, char **result);
PDICR_Error_Code pdicr_heading_heading (const char *heading, char ** result);
PDICR_Error_Code pdicr_path_basename (const char *path, char **basename);

/* book.c */
int pdicr_book_is_bound (PDICR_Book *book);
int pdicr_book_is_initialized (PDICR_Book *book);
int pdicr_book_have_id (PDICR_Book *book);
void pdicr_book_initialize (PDICR_Book *book);
void pdicr_book_finalize (PDICR_Book *book);
PDICR_Error_Code pdicr_book_bind (PDICR_Book *book, const char *path);
PDICR_Error_Code pdicr_book_path (PDICR_Book *book, char **path);
PDICR_Error_Code pdicr_book_version
(PDICR_Book *book, PDICR_Version *version);
PDICR_Error_Code pdicr_book_character_code
(PDICR_Book *book, PDICR_Character_Code *character_code);
PDICR_Error_Code pdicr_book_id (PDICR_Book *book, char *id);
PDICR_Error_Code pdicr_book_fread
(PDICR_Book *book, PDICR_Position pos, size_t length, char *buffer);
PDICR_Error_Code pdicr_book_index_order
(PDICR_Book *book, PDICR_Index_Order *order);
PDICR_Error_Code pdicr_book_pron_table_coding
(PDICR_Book *book, PDICR_Pron_Table_Code *pron_coding);
PDICR_Error_Code pdicr_book_set_pron_table_coding
(PDICR_Book *book, PDICR_Pron_Table_Code pron_coding);

/* entry.c */
void pdicr_entry_initialize (PDICR_Entry *entry);
void pdicr_entry_finalize (PDICR_Entry *entry);
int pdicr_entry_is_set(PDICR_Entry *entry);
int pdicr_entry_is_initialized (PDICR_Entry *entry);
PDICR_Error_Code pdicr_entry_heading
(PDICR_Book *book, PDICR_Entry *entry, char **string);
PDICR_Error_Code pdicr_entry_heading_raw
(PDICR_Book *book, PDICR_Entry *entry, char **string);
PDICR_Error_Code pdicr_entry_set
(PDICR_Book *book, PDICR_Entry *entry, const char *heading,
 PDICR_Position position, size_t field_length, size_t field_number_size);
PDICR_Error_Code pdicr_entry_set_raw
(PDICR_Book *book, PDICR_Entry *entry, const char *heading,
 PDICR_Position position, size_t field_length, size_t field_number_size);

/* search.c */
void pdicr_dump_initialize (PDICR_Search *search);
void pdicr_dump_finalize (PDICR_Search *search);
void pdicr_dump_set_set (PDICR_Search *search);
int pdicr_dump_is_set (PDICR_Search *search);
void pdicr_dump_set_started (PDICR_Search *search);
int pdicr_dump_is_started (PDICR_Search *search);
int pdicr_dump_is_initialized (PDICR_Search *search);
void pdicr_dump_set_ended (PDICR_Search *search);
int pdicr_dump_is_ended (PDICR_Search *search);
PDICR_Error_Code pdicr_dump_dump
(PDICR_Book *book, PDICR_Search *search, PDICR_Content *content);

/* content.c */
void pdicr_content_initialize (PDICR_Content *content);
void pdicr_content_finalize (PDICR_Content *content);
int pdicr_content_is_initialized (PDICR_Content *content);
int pdicr_content_is_loaded (PDICR_Content *content);
PDICR_Error_Code pdicr_content_load
(PDICR_Book *book, PDICR_Entry *entry, PDICR_Content *content);
PDICR_Error_Code pdicr_content_heading
(PDICR_Book *book, PDICR_Content *content, char **string);
PDICR_Error_Code pdicr_content_keyword
(PDICR_Book *book, PDICR_Content *content, char **string);
PDICR_Error_Code pdicr_content_heading_raw
(PDICR_Book *book, PDICR_Content *content, char **string);
PDICR_Error_Code pdicr_content_text
(PDICR_Book *book, PDICR_Content *content, char **string);
PDICR_Error_Code pdicr_content_text_raw
(PDICR_Book *book, PDICR_Content *content, char **string);
PDICR_Error_Code pdicr_content_pron
(PDICR_Book *book, PDICR_Content *content, char **string);
PDICR_Error_Code pdicr_content_pron_raw
(PDICR_Book *book, PDICR_Content *content, char **string);
PDICR_Error_Code pdicr_content_citation
(PDICR_Book *book, PDICR_Content *content, char **string);
PDICR_Error_Code pdicr_content_citation_raw
(PDICR_Book *book, PDICR_Content *content, char **string);
int pdicr_content_have_text (PDICR_Content *content);
int pdicr_content_have_citation (PDICR_Content *content);
int pdicr_content_have_pron (PDICR_Content *content);
int pdicr_content_is_important (PDICR_Content *content);
int pdicr_content_is_modified (PDICR_Content *content);
int pdicr_content_level (PDICR_Content *content);

#endif
