#                                                         -*- Perl -*-
# Copyright (c) 2007  Kazuhiro Ito
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

use strict;
use warnings;
# use Getopt::Long;

use English;
use FileHandle;
# use Compress::Raw::Zlib;

 MAIN: {

   if ( $#ARGV < 2) {
     print "$PROGRAM_NAME: Too few arguments.\n\n";
     print "  $PROGRAM_NAME deffile srcdir outdir\n";
     die "\n";
   }

   my $table_filename = $ARGV[0];
   my $srcdir = $ARGV[1];
   my $destdir = $ARGV[2];
   $srcdir =~ s/^(.+?)\/?$/$1/;

   my $src_filename;
   my $dest_filename;

   my @gaiji_table = read_defs($table_filename);

   #
   # make lookup package file.
   #

   $table_filename = "oald7-pkg.el";
   $src_filename =  "$srcdir/$table_filename".'.in';
   $dest_filename = "$destdir/$table_filename";
   

   my $src_handle = new FileHandle;
   if (!$src_handle->open("$src_filename", 'r')) {
     die "$PROGRAM_NAME: Failed to open the file, $ERRNO: $src_filename\n";
   }

   my $dest_handle = new FileHandle;
   if (!$dest_handle->open("$dest_filename", 'w')) {
     die "$PROGRAM_NAME: Failed to open the file, $ERRNO: $dest_filename\n";
   }

   my $text;
   while ($text = $src_handle->getline()) {
     $dest_handle->print($text);
     if ($text =~ /gaiji-table is here./) {
       insert_lookup_gaiji_table($dest_handle, @gaiji_table);
     }
   }

   $src_handle->close();
   $dest_handle->close();

   #
   # make lookup package file.
   #

   $table_filename = "OALD7.map";
   $src_filename =  "$srcdir/$table_filename".'.in';
   $dest_filename = "$destdir/$table_filename";
   

   $src_handle = new FileHandle;
   if (!$src_handle->open("$src_filename", 'r')) {
     die "$PROGRAM_NAME: Failed to open the file, $ERRNO: $src_filename\n";
   }

   $dest_handle = new FileHandle;
   if (!$dest_handle->open("$dest_filename", 'w')) {
     die "$PROGRAM_NAME: Failed to open the file, $ERRNO: $dest_filename\n";
   }

   $text;
   while ($text = $src_handle->getline()) {
     $dest_handle->print($text);
     if ($text =~ /gaiji-table is here./) {
       insert_ebwin_gaiji_table($dest_handle, @gaiji_table);
     }
   }

   $src_handle->close();
   $dest_handle->close();

}

sub insert_lookup_gaiji_table {
  my ($handle, @table) = @_;

  my $entry;
  my $char;
  foreach $entry (@table) {
    $char = utf8_char(hex($$entry[1]));
    $handle->print("     (\"h$$entry[0]\" \"$char\")\n");
  }

  return 0;
}

sub insert_ebwin_gaiji_table {
  my ($handle, @table) = @_;

  my $entry;
  foreach $entry (@table) {
    $handle->print("h$$entry[0]\tu$$entry[1]\t\n");
  }

  return 0;
}

sub read_defs {
  my ($filename) = @_;
  my @table;

  my $handle = new FileHandle;
  if (!$handle->open("$filename", 'r')) {
    die "$PROGRAM_NAME: Failed to open the file, $ERRNO: $filename\n";
  }

  my $def;
  while ($def = $handle->getline()) {
    my ($uni, $gaiji) = $def =~ /^u-([0-9A-Fa-f]+)[\t ]+(.+?)$/;
    # $uni = utf8_char(hex($uni));
    print "gaiji h$gaiji is allocated to $uni.\n";
    push (@table, ([$gaiji, $uni]));
  }
  $handle->close();

  return @table;
}

sub utf8_char {
  my $number = $_[0];

  if      ($number & 0x7c000000) {
    return
	chr(0xfc | (($number >> 30) & 0x01)).
	chr(0x80 | (($number >> 24) & 0x3f)).
	chr(0x80 | (($number >> 18) & 0x3f)).
	chr(0x80 | (($number >> 12) & 0x3f)).
	chr(0x80 | (($number >>  6) & 0x3f)).
	chr(0x80 | ($number & 0x3f));
  } elsif ($number & 0x03e00000) {
    return
	chr(0xf8 | (($number >> 24) & 0x03)).
	chr(0x80 | (($number >> 18) & 0x3f)).
	chr(0x80 | (($number >> 12) & 0x3f)).
	chr(0x80 | (($number >>  6) & 0x3f)).
	chr(0x80 | ($number & 0x3f));
  } elsif ($number & 0x001f0000) {
    return
	chr(0xf0 | (($number >> 18) & 0x07)).
	chr(0x80 | (($number >> 12) & 0x3f)).
	chr(0x80 | (($number >>  6) & 0x3f)).
	chr(0x80 | ($number & 0x3f));
  } elsif ($number & 0x0000f800) {
    return
	chr(0xe0 | (($number >> 12) & 0x0f)).
	chr(0x80 | (($number >>  6) & 0x3f)).
	chr(0x80 | ($number & 0x3f));
  } elsif ($number & 0x00000780) {
    return
	chr(0xc0 | (($number >>  6) & 0x1f)).
	chr(0x80 | ($number & 0x3f));
  }
  return chr($number);
}
