;;; chujiten.el --- supplement file for 「新英和・和英中辞典」 -*- coding: utf-8; lexical-binding: t -*-
;; Copyright (C) 1999 Lookup Development Team <lookup@ring.gr.jp>

;; Author: Keisuke Nishida <kei@psn.net>
;; Target: ndtp 1.0, ndeb 1.0, ndebs 0.1
;; Format: 1.1
;; Version: $Id$

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software Foundation,
;; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;;; Code:

(require 'lookup-package)

(defconst chujiten-gaiji-table
  (lookup-new-gaiji-table
   '(("ha121" "(+)") ("ha122" "(++)") ("ha123" "(+++)") ("ha124" "(o)")
     ("ha125" "˘" "^") ("ha126" nil "【") ("ha127" nil "】")
     ("ha128" "[") ("ha129" "]") ("ha12a" nil "~") ("ha12b" "-")
     ("ha12c" nil "'-") ("ha12d" nil "`-") ("ha12e" nil "a") ("ha12f" nil "e")
     ("ha130" "i") ("ha131" nil "^") ("ha132" "˘" "^") ("ha133" nil ",")
     ("ha134" "ç") ("ha135" nil "ə") ("ha136" nil "ɚ") ("ha137" nil "ɪ")
     ("ha138" nil "ɔ") ("ha139" nil "ʊ") ("ha13a" nil "ɑ") ("ha13b" "´" "'")
     ("ha13c" nil "E") ("ha13d" "á" "a") ("ha13e" "é" "e") ("ha13f" "í" "i")
     ("ha140" "ó" "o") ("ha141" "ú" "u") ("ha142" nil "ʌ") ("ha143" nil "ə")
     ("ha144" nil "ɚ") ("ha145" nil "ɪ") ("ha146" nil "ɔ") ("ha147" nil "ʊ")
     ("ha148" nil "ɑ") ("ha149" nil "`") ("ha14a" "à" "a") ("ha14b" "è" "e")
     ("ha14c" "ì" "i") ("ha14d" "ò" "o") ("ha14e" "ù" "u") ("ha14f" nil "ʌ")
     ("ha150" "ʌ") ("ha151" "Á" "A") ("ha152" nil "B") ("ha153" "Ć" "C")
     ("ha154" nil "D") ("ha155" "É" "E") ("ha156" nil "F") ("ha157" nil "G")
     ("ha158" nil "H") ("ha159" "Í" "I") ("ha15a" "Ĺ" "L") ("ha15b" nil "M")
     ("ha15c" "Ó" "O") ("ha15d" nil "P") ("ha15e" nil "Q") ("ha15f" "Ŕ" "R")
     ("ha160" "Ś" "S") ("ha161" nil "T") ("ha162" "Ú" "U") ("ha163" nil "V")
     ("ha164" nil "X") ("ha165" "Ý" "Y") ("ha166" "Ź" "Z") ("ha167" "á" "a")
     ("ha168" "é" "e") ("ha169" "í" "i") ("ha16a" "ó" "o") ("ha16b" "ú" "u")
     ("ha16c" "ý" "y") ("ha16d" "À" "A") ("ha16e" "È" "E") ("ha16f" "Ì" "I")
     ("ha170" "Ò" "O") ("ha171" nil "æ") ("ha172" nil "") ("ha173" nil "æ")
     ("ha174" nil "") ("ha175" "æ") ("ha176" "") ("ha177" nil "S")
     ("ha178" nil "T") ("ha179" "Ù" "U") ("ha17a" nil "V") ("ha17b" "à" "a")
     ("ha17c" "è" "e") ("ha17d" "ì" "i") ("ha17e" "ò" "o")
     ("ha221" "ù" "u") ("ha222" nil "y") ("ha223" "ɛ̃") ("ha224" "ɔ̃")
     ("ha225" "ɑ̃") ("ha226" "ə") ("ha227" "ɚ") ("ha228" "ɪ") ("ha229" "ɔ")
     ("ha22a" "ʊ") ("ha22b" "ɵ") ("ha22c" "ð") ("ha22d" "ʃ") ("ha22e" "ʒ")
     ("ha22f" "ŋ") ("ha230" nil "/t") ("ha231" nil "|o") ("ha232" nil "_?")
     ("ha233" "ː") ("ha234" "ɑ") ("ha235" "ł") ("ha236" "~") ("ha237" "ã")
     ("ha238" "ñ") ("ha239" "ø") ("ha23a" "Å") ("ha23b" "ţ") ("ha23c" nil "*")
     ("ha23d" "¨") ("ha23e" "Ö") ("ha23f" "ä") ("ha240" "ë") ("ha241" "ï")
     ("ha242" "ö") ("ha243" "ü") ("ha244" "^") ("ha245" "â") ("ha246" "ê")
     ("ha247" "î") ("ha248" "ô") ("ha249" nil "=") ("ha24a" nil "=a")
     ("ha24b" "=e") ("ha24c" "=i") ("ha24d" "=o") ("ha24e" "=u") ("ha24f" "=y")
     ("ha250" "ă")  ("ha253" "Č") ("ha255" "č") ("ha257" "ľ") ("ha258" "ř")
     ("ha259" "š") ("ha25a" nil "m") ("ha25b" nil "4") ("ha25c" nil "8")
     ("ha25d" nil "b") ("ha25e" nil "f") ("ha25f" nil "h") ("ha260" nil "n")
     ("ha261" nil "p") ("ha262" nil "q") ("ha263" nil "r") ("ha264" nil "t")
     ("ha265" nil "1") ("ha266" nil "3") ("ha267" nil "s") ("ha268" nil "Y-")
     ("ha269" nil "$") ("ha26a" nil "\"") ("ha26b" "*") ("ha26c" nil "N")
     ("ha26d" nil "E") ("ha26e" nil "C") ("ha26f" nil "D") ("ha270" nil "G")
     ("ha271" nil "N") ("ha272" nil "P") ("ha273" nil "Q")
     ("ha274" nil "œ") ("ha275" nil "") ("ha276" nil "œ̃") ("ha277" nil "")
     ("ha278" nil "œ") ("ha279" nil "") ("ha27a" nil "e") ("ha27b" nil "1")
     ("ha27c" nil "2") ("ha27d" nil "3") ("ha27e" nil "4") ("ha321" nil "5")
     ("ha322" nil "6") ("ha323" nil "7") ("ha324" nil "8") ("ha325" nil "9")
     ("ha326" nil "0") ("ha327" nil "-") ("ha328" nil "+") ("ha329" nil "n")
     ("ha32a" nil "x") ("ha32b" nil "b") ("ha32c" nil "1") ("ha32d" nil "2")
     ("ha32e" nil "3") ("ha32f" nil "4") ("ha330" nil "5") ("ha331" nil "6")
     ("ha332" nil "7") ("ha333" nil "8") ("ha334" nil "9") ("ha335" nil "0")
     ("ha336" nil "-") ("ha337" nil "+") ("ha338" nil "a") ("ha339" nil "e")
     ("ha33a" nil "i") ("ha33b" nil "j") ("ha33c" nil "k") ("ha33d" nil "m")
     ("ha33e" nil "n") ("ha33f" nil "p") ("ha340" nil "r") ("ha341" nil "s")
     ("ha342" nil "v") ("ha343" nil "x") ("ha344" nil "y") ("ha345" nil "z")
     ("ha346" nil "'") ("ha347" nil "`") ("ha348" nil "\"") ("ha349" nil "^")
     ("ha34a" nil "v") ("ha34b" nil "-") ("ha34c" nil "~") ("ha34d" nil "*")
     ("ha34e" nil ",") ("ha34f" nil ",") ("ha350" nil ".") ("ha351" nil "ł")
     ("ha354" "♩") ("ha357" "œ") ("ha358" "á") ("ha359" "é") ("ha35a" "ó")
     ("ha35b" "à") ("ha35c" "è") ("ha35d" "â") ("ha35e" "ê") ("ha35f" "î")
     ("ha360" "ô") ("ha361" "ä") ("ha362" "ë") ("ha363" "ö") ("ha364" "ü")
     ("ha365" "ñ") ("ha366" nil "a") ("ha367" "ç")
     ("ha372" nil "2") ("ha373" nil "3") ("ha374" nil "0") ("ha375" nil "1")
     ("ha376" nil "2") ("ha377" nil "3") ("ha378" nil "4") ("ha379" nil "5")
     ("ha37a" nil "6") ("ha37b" nil "8") ("ha37c" nil "1") ("ha37d" nil "4")
     ("ha37e" nil "5") ("ha421" nil "7") ("ha422" nil "8") ("ha423" nil "9")
     ("ha424" nil "a") ("ha425" nil "G") ("ha426" nil "P")
     ("ha429" nil "x") ("ha42a" nil "+") ("ha42b" nil "-") ("ha42c" nil "+")
     ("ha430" nil "0") ("ha431" nil "6") ("ha432" "Å") ("ha433" nil "n")
     ("za321" "[名]") ("za322" "[代]") ("za323" "[形]") ("za324" "[動]")
     ("za325" "[副]") ("za326" "[接]") ("za327" "[前]") ("za328" "[冠]")
     ("za329" "[間]") ("za32a" "[助") ("za32b" "動]") ("za32c" "[接")
     ("za32d" "頭]") ("za32e" "尾]") ("za32f" "[U]") ("za330" "[C]")
     ("za331" "(単)") ("za332" "(複)") ("za333" "[A]") ("za334" "[P]")
     ("za335" "(自)") ("za336" "(他)") ("za337" "[成") ("za338" "句]")
     ("za339" nil "<音>") ("za33a" nil "<例>") ("za33b" nil "<メモ>")
     ("za33c" nil "<一覧>") ("za33f" "☞") ("za34e" "−") ("za34f" "↔")
     ("za37c" "(C)") ("za37d" "(R)") ("za722" "⇒"))))

(defconst chujiten-arranges
  '(lookup-arrange-gaijis
    chujiten-arrange-references
    chujiten-arrange-levels
    lookup-arrange-fill-lines))

(setq lookup-package-dictionary-options
      (list (cons ':gaiji-table chujiten-gaiji-table)
	    (cons ':arranges chujiten-arranges)
	    (cons ':stemmer 'stem-english)))

(defconst chujiten-reference-regexp
  (cond ((eq lookup-package-agent 'ndtp)
	 "→<\\([0-9a-f:]+\\)>")
	((eq lookup-package-agent 'ndeb)
	 "<reference>→</reference=\\([0-9a-f:]+\\)>")))

(defconst chujiten-eiwa-reference-regexp
  (concat chujiten-reference-regexp "\\([a-zA-Z' ]*[０-９]*\\>\\)"))

(defconst chujiten-waei-reference-regexp
  (concat chujiten-reference-regexp "\\([^ ,.\n]*\\)"))

(declare-function lookup-arrange-references "lookup-vse" (entry))

(defun chujiten-arrange-references (entry)
  (if (chujiten-menu-entry-p entry)
      (lookup-arrange-references entry)
    (let ((case-fold-search nil)
	  (dictionary (lookup-entry-dictionary entry))
	  (regexp (if (chujiten-eiwa-entry-p entry)
		      chujiten-eiwa-reference-regexp
		    chujiten-waei-reference-regexp))
	  start code heading)
      (while (re-search-forward regexp nil t)
	(setq start (match-beginning 0))
	(setq code (match-string 1) heading (match-string 2))
	(replace-match (concat "→" heading) t t)
	(setq entry (lookup-make-entry dictionary code heading))
	(lookup-set-link start (point) entry)))))

(defun chujiten-arrange-levels (entry)
  (if (chujiten-eiwa-entry-p entry)
      (chujiten-eiwa-arrange-levels entry)
    (chujiten-waei-arrange-levels entry)))

(declare-function lookup-make-region-heading "lookup-vse" (start end level))

(defun chujiten-eiwa-arrange-levels (_entry)
  ;; 見出し語を level 1
  (when (looking-at "\\(([+o]+)\\)?\\([^/\n]*\\) *\\(/[^/\n]+/\\)?$")
    (lookup-make-region-heading (match-beginning 2) (match-end 2) 1))
  (forward-line)
  ;; level 2-6
  (let ((case-fold-search nil) n
	(regexp (concat "^\\(−\\[[^]\n]+\\]\\)\\|"	; level 2
			"^\\([A-Z]\\>\\)\\|"		; level 3
			"^\\([0-9]+\\)?\\([a-z]\\)?\\>\\|" ; level 4, 5
			"^\\(\\*.*\\)"))) ; level 6
    (while (re-search-forward regexp nil t)
      (setq n 1)
      (while (<= n 6)
	(if (match-beginning n)
	    (lookup-make-region-heading
	     (match-beginning n) (match-end n) (1+ n)))
	(setq n (1+ n))))))

(defun chujiten-waei-arrange-levels (_entry)
  (lookup-make-region-heading (point) (progn (end-of-line) (point)) 1)
  (forward-line)
  (while (re-search-forward "^\\([0-9]+\\)\\|^\\(【文例】\\)?\\(\\*.*\\)" nil t)
    (if (match-beginning 1)
	(lookup-make-region-heading (match-beginning 1) (match-end 0) 4)
      (lookup-make-region-heading (match-beginning 3) (match-end 3) 6))))

(defun chujiten-eiwa-entry-p (entry)
  (string< (lookup-entry-code entry) "6e8d"))

(defun chujiten-menu-entry-p (entry)
  (let ((code (lookup-entry-code entry)))
    (or (string< code "17a2") (string< "a773" code))))

;;; chujiten.el ends here
