/*                                                            -*- C -*-
 * Copyright (c) 2019  Kazuhiro Ito
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef DZZIP_DEFS_H
#define DZZIP_DEFS_H

#ifndef O_BINARY
#define O_BINARY 0
#endif

/* constants */
#define DICTZIP_MAX_CHUNK_COUNT ((0xffff - 6) / 2)
#define DICTZIP_DEFAULT_CHUNK_SIZE (58315) /* from dictzip */
#define DICTZIP_MAX_CHUNK_SIZE (0xffff)
#define DICTZIP_HEADER_SIZE (22)
#define DZZIP_MIN_CHUNK_SIZE (1024)

enum dzzip_error_code {
  DZZIP_SUCCESS = 0,
  DZZIP_ERR_INVALID_INPUT_FILE,
  DZZIP_ERR_NOT_DICTZIP,
  DZZIP_ERR_NOT_GZIP,
  DZZIP_ERR_INVALID_BASE64,
  DZZIP_ERR_TOO_LONG_STRING,
  DZZIP_ERR_ZLIB_ERROR,
  DZZIP_ERR_TOO_LARGE_INPUT_FILE,
  DZZIP_ERR_MEMORY_EXHAUSTED,
  DZZIP_ERR_OUTPUT_EXISTS,
  DZZIP_ERR_FILE_IO,
  DZZIP_ERR_INVALID_INPUT_FILE_NAME,
  DZZIP_ERR_INVALID_DICTZIP,
  DZZIP_ERR_INVALID_START,
};

#endif
