# dzzip

dictzip compatible extractor / compressor  
Written by Kazuhiro Ito <kzhr@d1.dion.ne.jp>

## What's this?

dzzip is dictzip compatible file extractor for [Lookup (Japanese)](http://green.ribbon.to/~ikazuhiro/lookup/lookup.html).
It can also compress files into dictzip compatible format.

## Background

Lookup's ndic agent supports
[DICT](https://sourceforge.net/projects/dict/) formatted dictionaries.
they consist of index file and text file.  Text file can be compressed
by dictzip program.  dictzip can extract a part of uncompressed text
from compressed file and Lookup uses dictzip to access compressed
file.  But recent [dict](https://sourceforge.net/projects/dict/) and
[libmaa](https://sourceforge.net/projects/dict/) (required by dict)
package depend on [bmake](http://www.crufty.net/help/sjg/bmake.html)
and [mk-configure](https://sourceforge.net/projects/mk-configure/) at
build time.  mk-configure is somewhat hard to install common Windows
build environment such as MinGW and Cygwin for me.  So I made this
program which was easy to install in MinGW and Cygwin environment.

## Requirement

zlib.

## Limitation and differences from dictzip
### Unsupported options

`-p`, `-P`, `-t`, `-l` options are not implemented.

### New option

`-C` option indicates chunk size for compression.  Max value is 65535
(bytes).  Compressed chunk size is also limited up to 65535 bytes.
So, compression may fail if large chunk size is specified for very
complex data.  But it should not occur for normal text data.  There is
no theoretical lower limit, but dzzip accepts down to 1024.

### Differences

`-D` option does not take an argument.

`-D`, `-V` options's output is different from dictzip.

`-s`, `-S`, `-e`, `-E`, `-c` options turn on `-k` option implicitly.

dzzip does not include original file name into compressed file.

dzzip can change chunk size by `-C` option.

Default mode is always compression mode even when evoked as the name
such as `dzunzip`.

## License

MIT license.  See COPYING file for details.
