/*                                                            -*- C -*-
 * Copyright (c) 2010  Kazuhiro Ito
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "pdicr_internal.h"

struct Error_Table {
  PDICR_Error_Code code;
  char *message;
};

struct Error_Table pdicr_error_message_table[] = {
  {PDICR_SUCCESS, "no error"},
  {PDICR_ERR_BAD_FILE_NAME, "bad file name"},
  {PDICR_ERR_BOCU1_DECODE_FAILURE, "decoding BOCU-1 string is failed"},
  {PDICR_ERR_BOCU1_ENCODE_FAILURE, "encoding BOCU-1 string is failed"},
  {PDICR_ERR_FILE_IO, "file I/O error"},
  {PDICR_ERR_FREAD, "fread error"},
  {PDICR_ERR_FSEEK, "fseek error"},
  {PDICR_ERR_ICONV_FAILURE,"iconv failed"},
  {PDICR_ERR_ICONV_OPEN_FAILURE, "iconv_open failed"},
  {PDICR_ERR_INVALID_BOOK, "invalid book"},
  {PDICR_ERR_INVALID_CONTENT, "invalid content"},
  {PDICR_ERR_INVALID_ENTRY, "invalid entry"},
  {PDICR_ERR_INVALID_PRON_TABLE_CODE, "invalid pronuciation table code"},
  {PDICR_ERR_INVALID_SEARCH, "invalid search"},
  {PDICR_ERR_MEMORY_EXHAUSTED, "memory exhausted"},
  {PDICR_ERR_NO_BOOK_DEFAULT, "book default is not found"},
  {PDICR_ERR_NO_CITATION_CONTENT, "content doesn't have citation"},
  {PDICR_ERR_NO_ID, "book doesn't have id"},
  {PDICR_ERR_NO_KEYWORD_CONTENT, "content doesn't have keyword"},
  {PDICR_ERR_NO_PRON_CONTENT, "content doesn't have pronunciation"},
  {PDICR_ERR_NO_TEXT_CONTENT, "content doesn't have text"},
  {PDICR_ERR_TOO_LONG_PATH, "path is too long"},
  {PDICR_ERR_UNBOUND_BOOK, "book is unbound"},
  {PDICR_ERR_UNEXPECTED_DATA, "unexpected data"},
  {PDICR_ERR_UNSUPPORTED_BOOK, "unsupported book"},
  {PDICR_ERR_UNSUPPORTED_OPERATION, "unsupported operation"},
  {-1, "unknown error"},
};



char *pdicr_error_message (PDICR_Error_Code code) {
  int i;

  for (i = 0; (pdicr_error_message_table[i]).code != -1; i++)
    if (code == (pdicr_error_message_table[i]).code) break;

  return (pdicr_error_message_table[i]).message;
}

