;; -*- mode: emacs-lisp; coding: utf-8-unix -*-
;;; mime-emoji-ezweb.el --- ezweb support for mime-emoji

;; Copyright (C) 2010  Kazuhiro Ito

;; Author: Kazuhiro Ito <kzhr@d1.dion.ne.jp>
;; Keywords: MIME, mail, Japanese

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; 


;;; Code:
;; Require cp51932-decode translation table
(require 'japanese)

;; Constants
(defconst mime-emoji/ezweb-list
  (eval-when-compile
    (delq nil
	  (apply 'nconc
		 (let ((table (get 'cp51932-decode 'translation-table))
		       ch)
		   (mapcar
		    (lambda (elt)
		      (setq ch (decode-char 'japanese-jisx0208 (nth 0 elt)))
		      (list (list ch (nth 1 elt) (nth 2 elt))
			    ;; For the case iso-2022-jp decoder is
			    ;; actually cp50220 decoder.
			    (when (setq ch (aref table ch))
			      (list ch (nth 1 elt) (nth 2 elt)))))
		    '(
		      (#x753A "！" 1)
		      (#x753B "！" 2)
		      (#x753C "？" 3)
		      (#x7729 "？" 4)
		      (#x772A "左向き三角1" 5)
		      (#x772B "右向き三角1" 6)
		      (#x772C "左向き三角2" 7)
		      (#x772D "右向き三角2" 8)
		      (#x772E "小四角1" 9)
		      (#x772F "小四角2" 10)
		      (#x7730 "インフォメーションシンボル" 11)
		      (#x757A "ワイングラス" 12)
		      (#x766C "スピーカ" 13)
		      (#x7776 "ドル" 14)
		      (#x753F "三日月" 15)
		      (#x7540 "いなずま" 16)
		      (#x7731 "中四角1" 17)
		      (#x7732 "中四角2" 18)
		      (#x7733 "小菱形1" 19)
		      (#x7734 "小菱形2" 20)
		      (#x7735 "大四角1" 21)
		      (#x7736 "大四角2" 22)
		      (#x7737 "小丸1" 23)
		      (#x7738 "小丸2" 24)
		      (#x7777 "腕時計" 25)
		      (#x7739 "プラス" 26)
		      (#x773A "マイナス" 27)
		      (#x773B "星1" 28)
		      (#x773C "上矢印1" 29)
		      (#x773D "下矢印1" 30)
		      (#x773E "丸に斜め線" 31)
		      (#x773F "下三角1" 32)
		      (#x7740 "上三角1" 33)
		      (#x7741 "下三角2" 34)
		      (#x7742 "上三角2" 35)
		      (#x7743 "大菱形1" 36)
		      (#x7744 "大菱形2" 37)
		      (#x7745 "特大四角1" 38)
		      (#x7746 "特大四角2" 39)
		      (#x7747 "大丸1" 40)
		      (#x7748 "大丸2" 41)
		      (#x7749 "上矢印2" 42)
		      (#x774A "下矢印2" 43)
		      (#x7541 "太陽" 44)
		      (#x7573 "野球ボール" 45)
		      (#x7833 "時計" 46)
		      (#x7542 "満月(顔付き)" 47)
		      (#x766D "ベル" 48)
		      (#x775D "プッシュピン(画鋲)" 49)
		      (#x7655 "小顔" 50)
		      (#x7834 "ハート" 51)
		      (#x757B "マティーニ(カクテルグラス)" 52)
		      (#x766E "四つ葉" 53)
		      (#x774B "トレードマーク(TM)" 54)
		      (#x774C "かける" 55)
		      (#x775E "文書1" 56)
		      (#x7778 "砂時計1" 57)
		      (#x7535 "砂時計2" 58)
		      (#x775F "フロッピーディスク" 59)
		      (#x7543 "雪の結晶" 60)
		      (#x774D "バツ1" 61)
		      (#x774E "バツ2" 62)
		      (#x774F "右矢印1" 63)
		      (#x7750 "左矢印1" 64)
		      (#x757C "マグカップ" 65)
		      (#x7751 "割る" 66)
		      (#x7760 "カレンダー" 67)
		      (#x7656 "スマイルフェイス" 68)
		      (#x7544 "星２" 69)
		      (#x7752 "右矢印2" 70)
		      (#x7753 "左矢印" 71)
		      (#x766F "ジュエ2リー" 72)
		      (#x7754 "チェックマーク1" 73)
		      (#x763A "犬(プードル)" 74)
		      (#x7521 "流れ星" 75)
		      (#x7525 "スパーク" 76)
		      (#x752F "電球" 77)
		      (#x763B "鳥" 78)
		      (#x782E "フォルダ1 (閉)" 79)
		      (#x7657 "顔1" 80)
		      (#x7755 "コピーライトマーク" 81)
		      (#x7756 "レジスタードマーク" 82)
		      (#x7555 "ブリーフケース(ハンドバッグ)" 83)
		      (#x782F "フォルダ2 (開)" 84)
		      (#x7835 "電話1 (プッシュホン)" 85)
		      (#x7658 "吹き出しコメント" 86)
		      (#x7779 "クレジットカード" 87)
		      (#x7757 "上三角3" 88)
		      (#x7758 "下三角3" 89)
		      (#x7770 "USA" 90)
		      (#x7556 "ノート3" 91)
		      (#x7761 "クリップボード" 92)
		      (#x7836 "カップ" 93)
		      (#x7670 "カメラ" 94)
		      (#x7545 "雨" 95)
		      (#x7574 "フットボール" 96)
		      (#x7762 "本1" 97)
		      (#x753D "立ち入り禁止" 98)
		      (#x7523 "信号" 99)
		      (#x7763 "本2" 100)
		      (#x7764 "本3" 101)
		      (#x7765 "本4" 102)
		      (#x7766 "文書2" 103)
		      (#x7671 "はさみ" 104)
		      (#x7767 "ひめくりカレンダー" 105)
		      (#x7557 "チケット・キップ" 106)
		      (#x7546 "くもり" 107)
		      (#x767C "封筒" 108)
		      (#x777A "小切手 (CHECK)" 109)
		      (#x7672 "ビデオカメラ" 110)
		      (#x777B "ハンディカム" 111)
		      (#x7564 "家" 112)
		      (#x763F "花" 113)
		      (#x777C "ナイフ" 114)
		      (#x777D "ビデオテープ" 115)
		      (#x7659 "めがね" 116)
		      (#x7759 "回り矢印1" 117)
		      (#x775A "回り矢印2" 118)
		      (#x7673 "むしめがね" 119)
		      (#x7674 "鍵" 120)
		      (#x7768 "ノート1" 121)
		      (#x7558 "ノート2" 122)
		      (#x777E "ボルト＆ナット" 123)
		      (#x7675 "くつ" 124)
		      (#x756A "車" 125)
		      (#x7821 "フロッピー2" 126)
		      (#x7771 "チャート (棒グラフ)" 127)
		      (#x7772 "グラフ1 (折れ線グラフ)" 128)
		      (#x7676 "メールボックス" 129)
		      (#x7822 "懐中電灯" 130)
		      (#x7769 "Roldex" 131)
		      (#x775B "チェックマーク2" 132)
		      (#x7629 "はっぱ" 133)
		      (#x763C "猟犬" 134)
		      (#x7823 "電池" 135)
		      (#x775C "スクロール" 136)
		      (#x776A "がびょう" 137)
		      (#x7677 "錠前" 138)
		      (#x7824 "ドル札" 139)
		      (#x765A "指差し確認左" 140)
		      (#x765B "指差し確認右" 141)
		      (#x776B "台帳" 142)
		      (#x7559 "クリップ" 143)
		      (#x762A "プレゼント" 144)
		      (#x7678 "名札" 145)
		      (#x7565 "ゴハン1" 146)
		      (#x776C "複数本" 147)
		      (#x756B "トラック" 148)
		      (#x755A "エンピツ" 149)
		      (#x7825 "ロゴ (PDC社)" 150)
		      (#x7830 "封筒2" 151)
		      (#x7826 "レンチ" 152)
		      (#x7831 "送信BOX" 153)
		      (#x7832 "受信BOX" 154)
		      (#x7679 "電話2" 155)
		      (#x7566 "工場・建物" 156)
		      (#x776D "定規1" 157)
		      (#x755B "定規2" 158)
		      (#x7773 "グラフ2" 159)
		      (#x757D "食事2" 160)
		      (#x7827 "電話3" 161)
		      (#x7828 "コンセント" 162)
		      (#x765C "家族" 163)
		      (#x7829 "リンク" 164)
		      (#x767A "パッケージ" 165)
		      (#x767B "FAX" 166)
		      (#x7547 "ときどき曇り" 167)
		      (#x756C "飛行機" 168)
		      (#x756D "ボート (船)" 169)
		      (#x7623 "サイコロ" 170)
		      (#x782A "新聞" 171)
		      (#x756E "電車" 172)
		      (#x782B "全部ブランク" 173)
		      (#x782C "半分ブランク" 174)
		      (#x782D "4分の1ブランク" 175)
		      (#x7536 "喫煙" 176)
		      (#x7537 "禁煙" 177)
		      (#x7538 "車椅子" 178)
		      (#x7539 "若葉マーク" 179)
		      (#x767D "四角数字１" 180)
		      (#x767E "四角数字２" 181)
		      (#x7721 "四角数字３" 182)
		      (#x7722 "四角数字４" 183)
		      (#x7723 "四角数字５" 184)
		      (#x7724 "四角数字６" 185)
		      (#x7725 "四角数字７" 186)
		      (#x7726 "四角数字８" 187)
		      (#x7727 "四角数字９" 188)
		      (#x7728 "四角数字10" 189)
		      (#x7522 "台風" 190)
		      (#x753E "ゆきだるま" 191)
		      (#x7548 "星座 (おひつじ座)" 192)
		      (#x7549 "星座 (おうし座)" 193)
		      (#x754A "星座 (双子座)" 194)
		      (#x754B "星座 (かに座)" 195)
		      (#x754C "星座 (しし座)" 196)
		      (#x754D "星座 (おとめ座)" 197)
		      (#x754E "星座 (天秤座)" 198)
		      (#x754F "星座 (さそり座)" 199)
		      (#x7550 "星座 (いて座)" 200)
		      (#x7551 "星座 (やぎ座)" 201)
		      (#x7552 "星座 (水瓶座)" 202)
		      (#x7553 "星座 (うお座)" 203)
		      (#x7554 "星座 (へびつかい座)" 204)
		      (#x755C "ATM" 205)
		      (#x755D "24HOURS (コンビニ)" 206)
		      (#x755E "トイレ" 207)
		      (#x755F "パーキング" 208)
		      (#x7560 "バス停" 209)
		      (#x7561 "アンテナ (位置情報マーク)" 210)
		      (#x7562 "港 (いかりマーク)" 211)
		      (#x7563 "銀行" 212)
		      (#x776E "ガススタンド" 213)
		      (#x776F "地図" 214)
		      (#x7567 "自転車" 215)
		      (#x7568 "バス" 216)
		      (#x7569 "新幹線" 217)
		      (#x7524 "マラソン" 218)
		      (#x756F "サッカー" 219)
		      (#x7570 "テニス" 220)
		      (#x7571 "スノーボード" 221)
		      (#x7572 "チェッカーフラグ (モータースポーツ)" 222)
		      (#x7526 "遊園地" 223)
		      (#x7575 "温泉" 224)
		      (#x7576 "居酒屋 (赤ちょうちん)" 225)
		      (#x7577 "映画 (かちんこ)" 226)
		      (#x7578 "夜の橋" 227)
		      (#x7579 "東京タワー" 228)
		      (#x7527 "スロット (777)" 229)
		      (#x7528 "くす玉 (アタリのくす玉)" 230)
		      (#x757E "当選弓矢" 231)
		      (#x7621 "ゲームのコントローラ" 232)
		      (#x7622 "賞金" 233)
		      (#x7624 "クリスマスツリー" 234)
		      (#x7625 "花見 (さくら)" 235)
		      (#x7626 "お化け" 236)
		      (#x7627 "旗 (祝日・日の丸)" 237)
		      (#x7628 "スイカ" 238)
		      (#x762B "ケーキ" 239)
		      (#x762C "フライパン (目玉焼き)" 240)
		      (#x762D "さくらんぼ" 241)
		      (#x762E "ふぐ" 242)
		      (#x762F "イチゴ" 243)
		      (#x7630 "おにぎり" 244)
		      (#x7631 "ハンバーガー (ファーストフード)" 245)
		      (#x7529 "くじら" 246)
		      (#x7632 "うさぎ" 247)
		      (#x7633 "うま" 248)
		      (#x7634 "さる" 249)
		      (#x7635 "かえる" 250)
		      (#x7636 "猫" 251)
		      (#x7637 "ペンギン" 252)
		      (#x7638 "あり" 253)
		      (#x7639 "ぶた" 254)
		      (#x763D "やしのき" 255)
		      (#x763E "ひまわり" 256)
		      (#x752A "顔1(うれしいカオ)" 257)
		      (#x752B "顔2(おこったカオ)" 258)
		      (#x752C "顔3(かなしいカオ)" 259)
		      (#x752D "顔4(つかれたカオ)" 260)
		      (#x752E "眠い (ZZZ…)" 261)
		      (#x7640 "怒り (ムカッ)" 262)
		      (#x7641 "雫 (涙・汗)" 263)
		      (#x7642 "からかう (あっかんべえ)" 264)
		      (#x7530 "ハート2 (われている)" 265)
		      (#x7531 "ハート3 (大きい＆小さい)" 266)
		      (#x7532 "スパーク2 (キラリマーク)" 267)
		      (#x7533 "爆弾" 268)
		      (#x7534 "炎" 269)
		      (#x7643 "捜索 (SOS)" 270)
		      (#x7644 "力こぶ" 271)
		      (#x7645 "ハート5 (矢がささっている)" 272)
		      (#x7646 "キスマーク" 273)
		      (#x7647 "宇宙人" 274)
		      (#x7648 "なると" 275)
		      (#x7649 "足跡 (犬)" 276)
		      (#x764A "悪魔" 277)
		      (#x764B "花丸" 278)
		      (#x764C "丸秘" 279)
		      (#x764D "100点満点" 280)
		      (#x764E "パンチ" 281)
		      (#x764F "ダッシュ" 282)
		      (#x7650 "ウンチマーク" 283)
		      (#x7651 "人差し指サイン" 284)
		      (#x7652 "マル得" 285)
		      (#x7653 "どくろ" 286)
		      (#x7654 "おやゆびサイン" 287)
		      (#x765D "テレビ" 288)
		      (#x765E "マイク" 289)
		      (#x765F "財布" 290)
		      (#x7660 "メロディ" 291)
		      (#x7661 "ギター (エレキ)" 292)
		      (#x7662 "バイオリン (クラシック)" 293)
		      (#x7663 "ヘッドフォン" 294)
		      (#x7664 "口紅" 295)
		      (#x7665 "アクション (ピストル)" 296)
		      (#x7666 "エステ" 297)
		      (#x7774 "EZマーク" 298)
		      (#x7775 "無料 (FREE)" 299)
		      (#x7667 "CD/DVD" 300)
		      (#x7668 "婦人服" 301)
		      (#x7669 "UFO" 302)
		      (#x766A "更新 (UP!)" 303)
		      (#x766B "注射器 (血)" 304)
		      (#x7837 "霧" 305)
		      (#x7838 "ゴルフ" 306)
		      (#x7839 "バスケットボール" 307)
		      (#x783A "ポケットベル" 308)
		      (#x783B "アート" 309)
		      (#x783C "演劇" 310)
		      (#x783D "イベント" 311)
		      (#x783E "リボン" 312)
		      (#x783F "バースデー" 313)
		      (#x7840 "スペード" 314)
		      (#x7841 "ダイヤ" 315)
		      (#x7842 "クラブ" 316)
		      (#x7843 "目" 317)
		      (#x7844 "耳" 318)
		      (#x7845 "手 (チョキ)" 319)
		      (#x7846 "手 (パー)" 320)
		      (#x7847 "新月" 321)
		      (#x7848 "やや欠け月" 322)
		      (#x7849 "半月" 323)
		      (#x784A "クリア" 324)
		      (#x784B "四角数字０" 325)
		      (#x784C "決定" 326)
		      (#x784D "ふらふら" 327)
		      (#x784E "かわいい" 328)
		      (#x784F "どんっ (衝撃)" 329)
		      (#x7850 "あせあせ (飛び散る汗)" 330)
		      (#x7851 "イージープラス" 331)
		      (#x7852 "地球" 332)
		      (#x7853 "ラーメン" 333)
		      (#x7867 "NEW" 334)
		      (#x7868 "紳士服" 335)
		      (#x7869 "紳士靴" 336)
		      (#x786A "パソコン" 337)
		      (#x786B "ラジオ" 338)
		      (#x786C "バラ" 339)
		      (#x786D "チャペル" 340)
		      (#x786E "地下鉄" 341)
		      (#x786F "富士山" 342)
		      (#x7870 "八分音符" 343)
		      (#x7871 "天使" 344)
		      (#x7872 "トラ" 345)
		      (#x7873 "くま" 346)
		      (#x7874 "ねずみ" 347)
		      (#x7875 "ウィンク" 348)
		      (#x7876 "目がハート" 349)
		      (#x7877 "ショッキング" 350)
		      (#x7878 "困り" 351)
		      (#x7879 "たこ" 352)
		      (#x787A "ロケット" 353)
		      (#x787B "王冠" 354)
		      (#x787C "チュー" 355)
		      (#x787D "ハンマー" 356)
		      (#x787E "打ち上げ花火" 357)
		      (#x7921 "枯れ葉" 358)
		      (#x7922 "仕事かばん" 359)
		      (#x7923 "噴水" 360)
		      (#x7924 "キャンプ" 361)
		      (#x7925 "麻雀" 362)
		      (#x7926 "VS (バーサス)" 363)
		      (#x7927 "トロフィー" 364)
		      (#x7928 "カメ" 365)
		      (#x7929 "スペイン国旗" 366)
		      (#x792A "ロシア国旗" 367)
		      (#x792B "工事中" 368)
		      (#x792C "風呂" 369)
		      (#x792D "祝日マーク" 370)
		      (#x792E "夕方街並み" 371)
		      (#x792F "卵割り" 372)
		      (#x7930 "株価" 373)
		      (#x7931 "ポリス" 374)
		      (#x7932 "郵便局" 375)
		      (#x7933 "病院" 376)
		      (#x7934 "学校" 377)
		      (#x7935 "ホテル" 378)
		      (#x7936 "船" 379)
		      (#x7937 "18禁" 380)
		      (#x7938 "圏内" 381)
		      (#x7939 "COOL!" 382)
		      (#x793A "割マーク" 383)
		      (#x793B "ザ・マーク" 384)
		      (#x793C "IDマーク" 385)
		      (#x793D "満マーク" 386)
		      (#x793E "空マーク" 387)
		      (#x793F "指定マーク" 388)
		      (#x7940 "営業中マーク" 389)
		      (#x7941 "上指差し" 390)
		      (#x7942 "下指差し" 391)
		      (#x7943 "占い" 392)
		      (#x7944 "マナーモード" 393)
		      (#x7945 "電源OFF" 394)
		      (#x7946 "メモする" 395)
		      (#x7947 "ネクタイ" 396)
		      (#x7948 "ハイビスカス" 397)
		      (#x7949 "花束" 398)
		      (#x794A "サボテン" 399)
		      (#x794B "お銚子＆杯" 400)
		      (#x794C "乾杯" 401)
		      (#x794D "祝マーク" 402)
		      (#x794E "風邪薬" 403)
		      (#x794F "風船" 404)
		      (#x7950 "クラッカー" 405)
		      (#x7951 "eznavigation" 406)
		      (#x7952 "帽子" 407)
		      (#x7953 "ロングブーツ" 408)
		      (#x7954 "ネイル" 409)
		      (#x7955 "美容院" 410)
		      (#x7956 "床屋" 411)
		      (#x7957 "着物" 412)
		      (#x7958 "ビキニ" 413)
		      (#x7959 "ハート（トランプ）" 414)
		      (#x795A "光るハート" 415)
		      (#x795B "青ハート" 416)
		      (#x795C "緑ハート" 417)
		      (#x795D "黄ハート" 418)
		      (#x795E "紫ハート" 419)
		      (#x795F "きらきら" 420)
		      (#x7960 "スキー" 421)
		      (#x7961 "○" 422)
		      (#x7962 "日本茶" 423)
		      (#x7963 "食パン" 424)
		      (#x7964 "ソフトクリーム" 425)
		      (#x7965 "ポテト" 426)
		      (#x7966 "だんご" 427)
		      (#x7967 "おせんべい" 428)
		      (#x7968 "ごはん" 429)
		      (#x7969 "スパゲッティ" 430)
		      (#x796A "カレー" 431)
		      (#x796B "おでん" 432)
		      (#x796C "寿司" 433)
		      (#x796D "りんご" 434)
		      (#x796E "みかん" 435)
		      (#x796F "トマト" 436)
		      (#x7970 "なす" 437)
		      (#x7971 "弁当" 438)
		      (#x7972 "鍋" 439)
		      (#x7973 "ふっ" 440)
		      (#x7974 "しょんぼり" 441)
		      (#x7975 "勝ち誇り" 442)
		      (#x7976 "失敗" 443)
		      (#x7977 "わからん" 444)
		      (#x7978 "眠い" 445)
		      (#x7979 "てれてれ" 446)
		      (#x797A "青ざめ" 447)
		      (#x797B "風邪ひき" 448)
		      (#x797C "熱" 449)
		      (#x797D "横目" 450)
		      (#x797E "びっくり" 451)
		      (#x7A21 "あせり" 452)
		      (#x7A22 "楽譜" 453)
		      (#x7A23 "にこにこ" 454)
		      (#x7A24 "チュー2" 455)
		      (#x7A25 "チュッ" 456)
		      (#x7A26 "鼻" 457)
		      (#x7A27 "口" 458)
		      (#x7A28 "ゴメン/お願い" 459)
		      (#x7A29 "拍手" 460)
		      (#x7A2A "OK!" 461)
		      (#x7A2B "ブーイング" 462)
		      (#x7A2C "バイバイ" 463)
		      (#x7A2D "NG" 464)
		      (#x7A2E "OK!2" 465)
		      (#x7A2F "平謝り" 466)
		      (#x7A30 "カップル" 467)
		      (#x7A31 "バニー" 468)
		      (#x7A32 "トランペット" 469)
		      (#x7A33 "ビリヤード" 470)
		      (#x7A34 "水泳" 471)
		      (#x7A35 "消防車" 472)
		      (#x7A36 "救急車" 473)
		      (#x7A37 "パトカー" 474)
		      (#x7A38 "ジェットコースター" 475)
		      (#x7A39 "門松" 476)
		      (#x7A3A "雛祭り" 477)
		      (#x7A3B "卒業式" 478)
		      (#x7A3C "入学式" 479)
		      (#x7A3D "こいのぼり" 480)
		      (#x7A3E "傘" 481)
		      (#x7A3F "花嫁" 482)
		      (#x7A40 "かき氷" 483)
		      (#x7A41 "線香花火" 484)
		      (#x7A42 "巻き貝" 485)
		      (#x7A43 "風鈴" 486)
		      (#x7A44 "ハロウィン" 487)
		      (#x7A45 "お月見" 488)
		      (#x7A46 "サンタクロース" 489)
		      (#x7A47 "夜/流れ星" 490)
		      (#x7A48 "虹" 491)
		      (#x7A49 "ホテル2" 492)
		      (#x7A4A "日の出" 493)
		      (#x7A4B "シルクハット" 494)
		      (#x7A4C "デパート" 495)
		      (#x7A4D "城（日本）" 496)
		      (#x7A4E "城（ヨーロッパ）" 497)
		      (#x7A4F "工場2" 498)
		      (#x7A50 "フランス国旗" 499)
		      (#x7854 "Openwave" 500)
		      (#x7855 "ロック確認" 501)
		      (#x7856 "大文字" 502)
		      (#x7857 "小文字" 503)
		      (#x7858 "数字" 504)
		      (#x7859 "記号" 505)
		      (#x785A "アクセプト" 506)
		      (#x785B "チェックボックス" 507)
		      (#x785C "エディット" 508)
		      (#x785D "ラジオボタン" 509)
		      (#x785E "見る" 510)
		      (#x785F "戻る" 511)
		      (#x7860 "お気に入り" 512)
		      (#x7861 "終了" 513)
		      (#x7862 "ホーム" 514)
		      (#x7863 "受信箱1" 515)
		      (#x7864 "マーク" 516)
		      (#x7865 "個人" 517)
		      (#x7866 "再読み込み" 518)
		      (#x7A51 "ドイツ国旗" 700)
		      (#x7A52 "イタリア国旗" 701)
		      (#x7A53 "イギリス国旗" 702)
		      (#x7A54 "中国国旗" 703)
		      (#x7A55 "韓国国旗" 704)
		      (#x7A56 "白人" 705)
		      (#x7A57 "中国人" 706)
		      (#x7A58 "インド人" 707)
		      (#x7A59 "おじいさん" 708)
		      (#x7A5A "おばあさん" 709)
		      (#x7A5B "赤ちゃん" 710)
		      (#x7A5C "工事現場の人" 711)
		      (#x7A5D "お姫様" 712)
		      (#x7A5E "イルカ" 713)
		      (#x7A5F "ダンス" 714)
		      (#x7A60 "熱帯魚" 715)
		      (#x7A61 "げじげじ" 716)
		      (#x7A62 "象" 717)
		      (#x7A63 "コアラ" 718)
		      (#x7A64 "ホルスタイン" 719)
		      (#x7A65 "ヘビ" 720)
		      (#x7A66 "鶏" 721)
		      (#x7A67 "うりぼう" 722)
		      (#x7A68 "ふたこぶらくだ" 723)
		      (#x7A69 "Ａ型" 724)
		      (#x7A6A "Ｂ型" 725)
		      (#x7A6B "Ｏ型" 726)
		      (#x7A6C "AB型" 727)
		      (#x7A6D "足跡" 728)
		      (#x7A6E "スニーカー" 729)
		      (#x7A6F "旗" 730)
		      (#x7A70 "上向きカーブ矢印" 731)
		      (#x7A71 "下向きカーブ矢印" 732)
		      (#x7A72 "「！？」" 733)
		      (#x7A73 "「！！」" 734)
		      (#x7A74 "くるり" 735)
		      (#x7A75 "メロン" 736)
		      (#x7A76 "パイナップル" 737)
		      (#x7A77 "ぶどう" 738)
		      (#x7A78 "バナナ" 739)
		      (#x7A79 "とうもろこし" 740)
		      (#x7A7A "きのこ" 741)
		      (#x7A7B "栗" 742)
		      (#x7A7C "桃" 743)
		      (#x7A7D "やきいも" 744)
		      (#x7A7E "ピザ" 745)
		      (#x7B21 "ターキー" 746)
		      (#x7B22 "七夕笹飾り" 747)
		      (#x7B23 "トロピカルドリンク" 748)
		      (#x7B24 "辰" 749)
		      (#x7B25 "ピアノ" 750)
		      (#x7B26 "サーフィン" 751)
		      (#x7B27 "釣り" 752)
		      (#x7B28 "ボーリング" 753)
		      (#x7B29 "なまはげ" 754)
		      (#x7B2A "天狗" 755)
		      (#x7B2B "パンダ" 756)
		      (#x7B2C "あかんべー" 757)
		      (#x7B2D "ぶたの鼻" 758)
		      (#x7B2E "花" 759)
		      (#x7B2F "アイスクリーム" 760)
		      (#x7B30 "ドーナッツ" 761)
		      (#x7B31 "クッキー" 762)
		      (#x7B32 "チョコ" 763)
		      (#x7B33 "キャンディ（つつみ）" 764)
		      (#x7B34 "キャンディ（ぺろぺろ）" 765)
		      (#x7B35 "見ざる" 766)
		      (#x7B36 "言わざる" 767)
		      (#x7B37 "聞かざる" 768)
		      (#x7B38 "火山" 769)
		      (#x7B39 "リボンがけのハート" 770)
		      (#x7B3A "英語「ABC」" 771)
		      (#x7B3B "プリン" 772)
		      (#x7B3C "ミツバチ" 773)
		      (#x7B3D "テントウムシ" 774)
		      (#x7B3E "蜂蜜ポット" 775)
		      (#x7B3F "青りんご" 776)
		      (#x7B40 "羽のはえたお札" 777)
		      (#x7B41 "目がまわる時の記号" 778)
		      (#x7B42 "ぷー(かわいく怒)" 779)
		      (#x7B43 "ぶー（かわいく怒）（ネコ）" 780)
		      (#x7B44 "天の川" 781)
		      (#x7B45 "チュー（ネコ）" 782)
		      (#x7B46 "にこ(ネコ)" 783)
		      (#x7B47 "メールする" 784)
		      (#x7B48 "泣き笑い（ネコ）" 785)
		      (#x7B49 "泣き笑い" 786)
		      (#x7B4A "目がハート（ネコ）" 787)
		      (#x7B4B "ほえー（ネコ）" 788)
		      (#x7B4C "ほえー" 789)
		      (#x7B4D "涙ぽろり（ネコ）" 790)
		      (#x7B4E "涙ぽろり" 791)
		      (#x7B4F "きりり（ネコ）" 792)
		      (#x7B50 "ドレス" 793)
		      (#x7B51 "モヤイ象" 794)
		      (#x7B52 "駅" 795)
		      (#x7B53 "花札" 796)
		      (#x7B54 "ジョーカー" 797)
		      (#x7B55 "エビフライ" 798)
		      (#x7B56 "eメールアイコン" 799)
		      (#x7B57 "歩く人" 800)
		      (#x7B58 "パトカーのランプ" 801)
		      (#x7B59 "ezmovie" 802)
		      (#x7B5A "ドキドキしているハート" 803)
		      (#x7B5B "正面向きのひよこ" 804)
		      (#x7B5C "ジーンズ" 805)
		      (#x7B5D "ハートつきメール" 806)
		      (#x7B5E "循環矢印" 807)
		      (#x7B5F "左右両方向矢印" 808)
		      (#x7B60 "上下両方向矢印" 809)
		      (#x7B61 "荒波" 810)
		      (#x7B62 "双葉" 811)
		      (#x7B63 "かたつむり" 812)
		      (#x7B64 "うっしっし（ネコ）" 813)
		      (#x7B65 "うっしっし" 814)
		      (#x7B66 "Cメールアイコン" 815)
		      (#x7B67 "ハーブ" 816)
		      (#x7B68 "グー" 817)
		      (#x7B69 "＃" 818)
		      (#x7B6A "キャラクター（挙手）" 819)
		      (#x7B6B "キャラクター（万歳）" 820)
		      (#x7B6C "キャラクター（しょんぼり）" 821)
		      (#x7B6D "キャラクター（かわいく怒る）" 822)
		      (#x7B6E "EZアプリ（Java）" 823)
		      (#x7B6F "EZアプリ（BREW）" 824)
		      (#x7B70 "EZ着うた" 825)
		      (#x7B71 "EZナビMS" 826)
		      (#x7B72 "WIN" 827)
		      (#x7B73 "プレミアム" 828)
		      )))))))

;; Interface functions
(defun mime-emoji/ezweb-display-string (string)
  (let (elt)
    (dotimes (i (length string))
      (setq elt (mime-emoji/ezweb-get (string-to-char (substring string i))))
      (when elt
	(add-text-properties i (1+ i) `(display ,elt) string))))
  string)

(defun mime-emoji/ezweb-display-region (start end)
  (dotimes (i (- end start))
    (let ((elt (mime-emoji/ezweb-get (char-after (+ start i)))))
      (when elt
	(add-text-properties (+ start i) (+ start i 1) `(display ,elt))))))

;;Internal functions
(defun mime-emoji/ezweb-get (char)
  (let ((elt (assq char mime-emoji/ezweb-list)))
    (when elt
      (mime-emoji-get-emoji
       'ezweb (number-to-string (nth 2 elt)) (nth 1 elt)))))


(provide 'mime-emoji-ezweb)
;;; mime-emoji-ezweb.el ends here
