;; -*- coding: iso-2022-7bit  -*-
;;; ndsrd-pkg.el --- supplement package for $B>.3X4[!X%i%s%@%`%O%&%91Q8l<-E5!Y(B
;; Copyright (C) 2006 Kazuhiro Ito <kzhr@d1.dion.ne.jp>

;; Author: Kazuhiro Ito <kzhr@d1.dion.nejp>
;; Target: ndsrd
;; Format: 1.1
;; Version: 1.0

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software Foundation,
;; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;;; Code:

(require 'lookup-package)

(defconst ndsrd-gaiji-xbm-table
  '(("G0-27" "u-2019") ("G0-83" "u-0192") ("G0-84" "u-201e")
    ("G0-85" "u-2026") ("G0-86" "u-2020") ("G0-87" "u-2021")
    ("G0-8a" "u-0160") ("G0-8b" "u-2039") ("G0-8c" "z-008c")
    ("G0-97" "u-2015") ("G0-99" "z-0099") ("G0-9a" "u-0161")
    ("G0-9b" "u-203a") ("G0-9c" "z-009c") ("G0-9f" "u-0178")
    ("G0-a1" "u-00a1") ("G0-a2" "u-00a2") ("G0-a4" "u-00a4")
    ("G0-a6" "u-00a6") ("G0-a7" "u-00a7") ("G0-a8" "u-00a8")
    ("G0-a9" "j1-292a") ("G0-aa" "u-00aa") ("G0-ab" "u-00ab")
    ("G0-ac" "u-00ac") ("G0-ad" "u-00ad") ("G0-ae" "j1-2926")
    ("G0-af" "u-00af") ("G0-b0" "u-00b0") ("G0-b1" "u-00b1")
    ("G0-b2" "u-00b2") ("G0-b3" "u-00b3") ("G0-b4" "u-00b4")
    ("G0-b5" "u-00b5") ("G0-b7" "u-00b7") ("G0-b8" "u-00b8")
    ("G0-b9" "u-00b9") ("G0-ba" "u-00ba") ("G0-bb" "u-00bb")
    ("G0-bc" "z-00bc") ("G0-bd" "z-00bd") ("G0-be" "z-00be")
    ("G0-bf" "u-00bf") ("G0-c0" "u-00c0") ("G0-c1" "u-00c1")
    ("G0-c2" "u-00c2") ("G0-c3" "u-00c3") ("G0-c4" "u-00c4")
    ("G0-c5" "u-00c5") ("G0-c6" "z-00c6") ("G0-c7" "u-00c7")
    ("G0-c8" "u-00c8") ("G0-c9" "u-00c9") ("G0-ca" "u-00ca")
    ("G0-cb" "u-00cb") ("G0-cc" "u-00cc") ("G0-cd" "u-00cd")
    ("G0-ce" "u-00ce") ("G0-cf" "u-00cf") ("G0-d0" "u-00d0")
    ("G0-d1" "u-00d1") ("G0-d2" "u-00d2") ("G0-d3" "u-00d3")
    ("G0-d4" "u-00d4") ("G0-d5" "u-00d5") ("G0-d6" "u-00d6")
    ("G0-d7" "u-00d7") ("G0-d8" "u-00d8") ("G0-d9" "u-00d9")
    ("G0-da" "u-00da") ("G0-db" "u-00db") ("G0-dc" "u-00dc")
    ("G0-dd" "u-00dd") ("G0-de" "u-00de") ("G0-df" "u-00df")
    ("G0-e0" "u-00e0") ("G0-e1" "u-00e1") ("G0-e2" "u-00e2")
    ("G0-e3" "u-00e3") ("G0-e4" "u-00e4") ("G0-e5" "u-00e5")
    ("G0-e6" "z-00e6") ("G0-e7" "u-00e7") ("G0-e8" "u-00e8")
    ("G0-e9" "u-00e9") ("G0-ea" "u-00ea") ("G0-eb" "u-00eb")
    ("G0-ec" "u-00ec") ("G0-ed" "u-00ed") ("G0-ee" "u-00ee")
    ("G0-ef" "u-00ef") ("G0-f0" "u-00f0") ("G0-f1" "u-00f1")
    ("G0-f2" "u-00f2") ("G0-f3" "u-00f3") ("G0-f4" "u-00f4")
    ("G0-f5" "u-00f5") ("G0-f6" "u-00f6") ("G0-f7" "u-00f7")
    ("G0-f8" "u-00f8") ("G0-f9" "u-00f9") ("G0-fa" "u-00fa")
    ("G0-fb" "u-00fb") ("G0-fc" "u-00fc") ("G0-fd" "u-00fd")
    ("G0-fe" "u-00fe") ("G0-ff" "u-00ff") ("G1-27" "u-2019")
    ("G1-41" "u-0251") ("G1-42" "u-0254") ("G1-43" "h-0143")
    ("G1-44" "u-00e9") ("G1-45" "u-00e8") ("G1-46" "u-00ed")
    ("G1-47" "u-00ec") ("G1-48" "u-00fa") ("G1-49" "u-00f9")
    ("G1-4a" "z-014a") ("G1-4b" "z-014b") ("G1-4c" "h-014c")
    ("G1-4d" "h-014d") ("G1-4e" "h-014e") ("G1-4f" "h-014f")
    ("G1-50" "u-0283") ("G1-51" "h-0151") ("G1-52" "h-0152")
    ("G1-53" "h-0153") ("G1-54" "h-0154") ("G1-55" "u-00f3")
    ("G1-56" "u-00f2") ("G1-57" "z-0157") ("G1-58" "u-0113")
    ("G1-59" "u-012b") ("G1-5a" "u-016b") ("G1-5b" "u-014d")
    ("G1-5c" "u-0101") ("G1-5d" "u-0100") ("G1-5e" "u-0233")
    ("G1-5f" "h-015f") ("G1-60" "h-0160") ("G1-61" "u-0252")
    ("G1-62" "h-0162") ("G1-63" "u-0268") ("G1-64" "u-0111")
    ("G1-65" "h-0165") ("G1-66" "u-014c") ("G1-67" "h-0167")
    ("G1-68" "u-016a") ("G1-69" "u-00f0") ("G1-6a" "u-03b8")
    ("G1-6b" "u-00e1") ("G1-6c" "u-00e0") ("G1-6d" "u-00c1")
    ("G1-6e" "u-00c0") ("G1-6f" "u-00c9") ("G1-70" "u-00c8")
    ("G1-71" "h-0171") ("G1-72" "h-0172") ("G1-73" "u-0292")
    ("G1-74" "u-00cd") ("G1-76" "u-014b") ("G1-77" "u-0155")
    ("G1-78" "h-0178") ("G1-79" "u-00fd") ("G1-7a" "u-1ef3")
    ("G1-7b" "u-00da") ("G1-7c" "u-00d9") ("G1-7d" "u-01ff")
    ("G1-7e" "h-017e") ("G1-80" "u-0112") ("G1-81" "u-012a")
    ("G1-86" "u-025b") ("G1-87" "u-00dd") ("G1-88" "u-1ef2")
    ("G1-89" "u-0272") ("G1-8a" "h-018a") ("G1-8b" "u-0106")
    ("G1-8c" "h-018c") ("G1-91" "u-00ef") ("G1-92" "u-0129")
    ("G1-93" "u-00ee") ("G1-94" "u-00d4") ("G1-95" "u-0103")
    ("G1-96" "u-011f") ("G1-97" "u-012d") ("G1-98" "u-0115")
    ("G1-99" "u-016d") ("G1-9a" "u-014f") ("G1-9b" "h-019b")
    ("G1-9c" "h-019c") ("G1-9d" "u-0177") ("G1-9e" "u-011d")
    ("G1-9f" "h-019f") ("G1-a0" "h-01a0") ("G1-a1" "h-01a0")
    ("G1-a2" "u-00c2") ("G1-a3" "u-0175") ("G1-a5" "h-01a5")
    ("G1-a6" "h-01a6") ("G1-a7" "h-01a7") ("G1-a8" "h-01a8")
    ("G1-a9" "u-0250") ("G1-aa" "u-00df") ("G1-ab" "u-00e7")
    ("G1-ac" "h-01ac") ("G1-ad" "z-01ad") ("G1-ae" "u-0103")
    ("G1-af" "u-00af") ("G1-b0" "u-0227") ("G1-b2" "z-009c")
    ("G1-b4" "u-0263") ("G1-b6" "u-017c") ("G1-b7" "u-0227")
    ("G1-b9" "u-1e0f") ("G1-ba" "u-1e5f") ("G1-bb" "z-01bb")
    ("G1-bc" "h-01bc") ("G1-bd" "z-00c6") ("G1-be" "u-00f1")
    ("G1-bf" "u-00e3") ("G1-c0" "u-00f5") ("G1-c1" "u-0169")
    ("G1-c3" "u-028e") ("G1-c4" "u-1e41") ("G1-c5" "u-1e45")
    ("G1-c6" "u-0117") ("G1-c7" "u-1e92") ("G1-c8" "u-0647")
    ("G1-c9" "z-01c9") ("G1-ca" "u-0639") ("G1-cb" "z-01cb")
    ("G1-cc" "u-0627") ("G1-cd" "h-01cd") ("G1-ce" "h-01ce")
    ("G1-cf" "u-0159") ("G1-d0" "u-01f0") ("G1-d1" "u-01d4")
    ("G1-d2" "u-011b") ("G1-d3" "u-0161") ("G1-d4" "u-01ce")
    ("G1-d5" "u-010d") ("G1-d6" "u-01d0") ("G1-d7" "u-010c")
    ("G1-d8" "u-0148") ("G1-da" "u-02d6") ("G1-db" "z-01db")
    ("G1-dc" "z-01dc") ("G1-dd" "z-01dd") ("G1-de" "u-2113")
    ("G1-df" "u-1e2b") ("G1-e0" "u-1e53") ("G1-e1" "h-01e1")
    ("G1-e4" "u-062f") ("G1-e5" "u-1e17") ("G1-e6" "u-02d1")
    ("G1-e8" "z-01e8") ("G1-e9" "u-2125") ("G1-eb" "u-015b")
    ("G1-ec" "h-01ec") ("G1-ed" "u-01eb") ("G1-ee" "u-0155")
    ("G1-ef" "u-1e31") ("G1-f0" "u-05e6") ("G1-f1" "u-0628")
    ("G1-f2" "u-1e63") ("G1-f4" "h-01f4") ("G1-f5" "h-01f5")
    ("G1-f6" "h-01f6") ("G1-f7" "h-01f7") ("G1-fb" "u-02c0")
    ("G1-fc" "u-1e4d") ("G2-27" "u-2019") ("G2-40" "u-0141")
    ("G2-41" "u-05d4") ("G2-42" "u-00b7") ("G2-43" "u-0142")
    ("G2-44" "u-026b") ("G2-46" "h-0246") ("G2-47" "h-00f6")
    ("G2-48" "u-0273") ("G2-49" "z-0249") ("G2-4a" "z-024a")
    ("G2-4b" "h-024b") ("G2-52" "z-095c") ("G2-54" "u-028d")
    ("G2-55" "u-015f") ("G2-5b" "u-00f4") ("G2-5d" "u-00fc")
    ("G2-5f" "u-0163") ("G2-61" "h-0261") ("G2-62" "u-1e24")
    ("G2-63" "u-1e25") ("G2-64" "u-2627") ("G2-65" "u-01d2")
    ("G2-66" "u-1e6d") ("G2-67" "j1-2b52") ("G2-6f" "j1-292a")
    ("G2-75" "h-0275") ("G2-79" "u-1e0d") ("G2-7a" "h-027a")
    ("G2-7b" "u-0634") ("G2-7c" "u-1e0c") ("G2-7d" "u-01ff")
    ("G2-7e" "u-062f") ("G2-81" "z-0281") ("G2-83" "u-02d1")
    ("G2-84" "z-0284") ("G2-85" "z-0285") ("G2-86" "z-0286")
    ("G2-8a" "u-0127") ("G2-8b" "h-028b") ("G2-8c" "h-028c")
    ("G2-8d" "z-028d") ("G2-92" "u-027c") ("G2-95" "u-0105")
    ("G2-98" "h-0298") ("G2-99" "u-0641") ("G2-9e" "z-029e")
    ("G2-9f" "z-029f") ("G2-a1" "j1-2d7e") ("G2-a7" "u-063a")
    ("G2-aa" "u-05d1") ("G2-ab" "h-02ab") ("G2-af" "z-02af")
    ("G2-b1" "u-00e4") ("G2-b4" "h-02b4") ("G2-b5" "u-025f")
    ("G2-b6" "u-062d") ("G2-b8" "u-02c7") ("G2-b9" "u-0621")
    ("G2-ba" "h-02ba") ("G2-bc" "u-00e2") ("G2-bd" "h-02bd")
    ("G2-be" "h-02be") ("G2-c1" "u-05d7") ("G2-c2" "u-1e2f")
    ("G2-c6" "h-02c6") ("G2-c8" "h-02c8") ("G2-c9" "z-02c9")
    ("G2-ca" "u-025a") ("G2-cb" "u-0215") ("G2-cc" "u-030d")
    ("G2-cd" "z-02cd") ("G2-ce" "u-1e6c") ("G2-cf" "z-02cf")
    ("G2-d0" "u-203d") ("G2-d1" "h-02d1") ("G2-d3" "u-062c")
    ("G2-d5" "u-0643") ("G2-d8" "u-05e0") ("G2-d9" "u-05d3")
    ("G2-db" "u-05d0") ("G2-dc" "u-05e7") ("G2-dd" "h-02dd")
    ("G2-de" "h-02de") ("G2-e0" "u-0644") ("G2-e1" "h-02e1")
    ("G2-e2" "u-05dc") ("G2-e4" "j1-2322") ("G2-e8" "u-026c")
    ("G2-e9" "u-017a") ("G2-ea" "h-02ea") ("G2-eb" "h-02eb")
    ("G2-ec" "u-017f") ("G2-ed" "h-02ed") ("G2-ef" "u-00e5")
    ("G2-f0" "h-02f0") ("G2-f1" "h-02f1") ("G2-f2" "h-02f2")
    ("G2-f3" "u-016f") ("G2-f7" "u-05de") ("G2-f8" "u-05dd")
    ("G2-f9" "j1-2360") ("G2-fb" "h-02fb") ("G2-fc" "u-0645")
    ("G3-27" "u-2019") ("G3-40" "h-0340") ("G3-41" "u-1e93")
    ("G3-44" "j1-227a") ("G3-45" "h-0345") ("G3-46" "h-0346")
    ("G3-47" "u-00d1") ("G3-49" "u-05d2") ("G3-4a" "u-05da")
    ("G3-4b" "u-0646") ("G3-4c" "z-008c") ("G3-4f" "j1-232e")
    ("G3-50" "j1-232f") ("G3-52" "z-0352") ("G3-54" "u-05e4")
    ("G3-55" "u-05e3") ("G3-5e" "h-035e") ("G3-5f" "h-035f")
    ("G3-63" "u-1e15") ("G3-64" "u-00ea") ("G3-66" "u-017e")
    ("G3-67" "h-0367") ("G3-68" "u-00fb") ("G3-69" "h-0369")
    ("G3-6b" "u-0642") ("G3-6d" "u-0631") ("G3-70" "u-0119")
    ("G3-73" "h-0373") ("G3-74" "u-0295") ("G3-75" "u-015a")
    ("G3-76" "h-0376") ("G3-77" "u-028c") ("G3-78" "u-0635")
    ("G3-79" "u-1e62") ("G3-7a" "u-05e2") ("G3-7b" "u-05e5")
    ("G3-7c" "u-05e1") ("G3-80" "u-00ce") ("G3-81" "u-fb2a")
    ("G3-82" "u-0636") ("G3-84" "z-0384") ("G3-86" "u-fb2b")
    ("G3-87" "u-0633") ("G3-88" "u-0209") ("G3-89" "u-1ec7")
    ("G3-8a" "z-069f") ("G3-8c" "u-01e7") ("G3-8d" "G3-8d")
    ("G3-8f" "u-0637") ("G3-90" "u-062a") ("G3-91" "u-1e37")
    ("G3-92" "z-0392") ("G3-93" "u-05ea") ("G3-94" "u-05d8")
    ("G3-95" "u-062b") ("G3-96" "u-00fe") ("G3-98" "u-00b8")
    ("G3-9a" "u-042f") ("G3-9b" "u-0287") ("G3-9c" "u-012b")
    ("G3-9d" "h-039d") ("G3-9e" "u-0294") ("G3-9f" "h-039f")
    ("G3-a0" "h-03a0") ("G3-a1" "h-03a0") ("G3-a3" "u-1ed9")
    ("G3-a4" "h-03a4") ("G3-a8" "u-00f3") ("G3-a9" "u-0649")
    ("G3-aa" "h-03aa") ("G3-ab" "h-03ab") ("G3-ae" "u-05d9")
    ("G3-b1" "u-0632") ("G3-b2" "u-0638") ("G3-b3" "u-05d5")
    ("G3-b9" "u-0259") ("G3-ba" "j1-2271") ("G3-bc" "h-03bc")
    ("G3-bd" "u-1e47") ("G3-be" "u-1e5b") ("G3-bf" "h-03bf")
    ("G3-c1" "h-03c1") ("G3-c2" "u-1e05") ("G3-c3" "h-03c3")
    ("G3-c4" "u-0107") ("G3-c5" "u-1e43") ("G3-c6" "h-03c6")
    ("G3-c7" "u-00d3") ("G3-ca" "h-03ca") ("G3-cb" "h-03cb")
    ("G3-cc" "h-03cc") ("G3-cd" "u-0154") ("G3-ce" "h-03ce")
    ("G3-cf" "h-03cf") ("G3-d2" "h-03d2") ("G3-d3" "u-01f5")
    ("G3-d4" "h-03d4") ("G3-d5" "h-03d5") ("G3-d6" "h-03d6")
    ("G3-d7" "u-1e54") ("G3-d8" "h-03d8") ("G3-d9" "h-03d9")
    ("G3-da" "u-0143") ("G3-db" "h-03db") ("G3-dc" "h-03dc")
    ("G3-dd" "h-03dd") ("G3-de" "u-1e3e") ("G3-e1" "h-03e1")
    ("G3-e5" "u-1e33") ("G3-e6" "h-03e6") ("G3-e7" "h-03e7")
    ("G3-e8" "h-03e8") ("G3-e9" "h-03e9") ("G3-ea" "u-1e30")
    ("G3-eb" "h-03eb") ("G3-ec" "u-0139") ("G3-ed" "u-1e82")
    ("G3-ee" "h-03ee") ("G3-ef" "h-03ef") ("G3-f0" "h-03f0")
    ("G3-f1" "h-03f1") ("G3-f2" "h-028b") ("G3-f3" "h-03f3")
    ("G3-f4" "h-03f4") ("G3-f5" "u-00eb") ("G3-f6" "h-03f6")
    ("G3-f7" "h-03f7") ("G3-f8" "u-00dc") ("G3-f9" "h-03f9")
    ("G3-fa" "h-03fa") ("G3-fb" "u-1e3f") ("G4-0f" "j1-2256")
    ("G4-27" "u-2019") ("G4-40" "h-0440") ("G4-41" "h-0441")
    ("G4-42" "h-0442") ("G4-43" "h-0443") ("G4-44" "u-017d")
    ("G4-45" "h-0445") ("G4-46" "h-0446") ("G4-47" "h-0447")
    ("G4-48" "h-0448") ("G4-49" "h-0449") ("G4-4a" "h-044a")
    ("G4-4b" "u-00cc") ("G4-4c" "u-0179") ("G4-4d" "h-044d")
    ("G4-4e" "u-1e55") ("G4-4f" "h-044f") ("G4-50" "h-0450")
    ("G4-51" "h-0451") ("G4-52" "h-0452") ("G4-53" "h-0453")
    ("G4-54" "u-1e80") ("G4-55" "u-00d6") ("G4-56" "h-0456")
    ("G4-57" "u-01f4") ("G4-59" "u-0144") ("G4-5a" "h-045a")
    ("G4-5b" "h-045b") ("G4-5c" "h-045c") ("G4-5e" "h-045e")
    ("G4-5f" "h-045f") ("G4-60" "h-0460") ("G4-61" "z-0461")
    ("G4-62" "z-0462") ("G4-63" "u-010c") ("G4-64" "h-0464")
    ("G4-65" "z-0465") ("G4-66" "h-0466") ("G4-67" "h-0467")
    ("G4-68" "u-05db") ("G4-69" "u-05e8") ("G4-6a" "u-062e")
    ("G4-6b" "h-03c3") ("G4-6d" "h-03bf") ("G4-6e" "z-046e")
    ("G4-6f" "z-046f") ("G4-70" "u-0648") ("G4-71" "u-05df")
    ("G4-72" "G4-72") ("G4-73" "u-05d6") ("G4-76" "u-0131")
    ("G4-77" "u-02d0") ("G4-78" "u-00ca") ("G4-79" "h-0479")
    ("G4-7b" "j1-2256") ("G4-7c" "u-00cb") ("G4-7d" "j1-2257")
    ("G4-7e" "u-00cf") ("G4-80" "u-00fa") ("G4-88" "z-0488")
    ("G4-89" "j1-232a") ("G4-8a" "z-048a") ("G4-8b" "z-048b")
    ("G4-8c" "u-2026") ("G4-8d" "z-00bd") ("G4-8e" "z-048e")
    ("G4-8f" "z-00bc") ("G4-90" "z-0490") ("G4-91" "z-0491")
    ("G4-92" "z-0492") ("G4-93" "z-0493") ("G4-94" "z-0494")
    ("G4-95" "z-0495") ("G4-96" "z-0496") ("G4-97" "z-0497")
    ("G4-98" "z-0498") ("G4-99" "z-0499") ("G4-9a" "z-049a")
    ("G4-9b" "z-049b") ("G4-9c" "z-0488") ("G4-9f" "j1-2256")
    ("G4-a0" "j1-2257") ("G4-a1" "z-04a1") ("G4-a2" "z-04a2")
    ("G4-ce" "u-0265") ("G4-cf" "u-03b2") ("G5-27" "u-2019")
    ("G5-5b" "z-00c6") ("G5-5c" "z-008c") ("G5-5d" "u-00d8")
    ("G5-5e" "u-00c4") ("G5-5f" "u-00c1") ("G5-60" "u-00c0")
    ("G5-61" "u-00c2") ("G5-62" "u-00c3") ("G5-63" "u-00c5")
    ("G5-64" "u-0100") ("G5-65" "u-0102") ("G5-66" "u-00c7")
    ("G5-67" "u-0110") ("G5-68" "u-00cb") ("G5-69" "u-00c9")
    ("G5-6a" "u-00c8") ("G5-6b" "u-00ca") ("G5-6c" "u-0112")
    ("G5-6d" "u-0114") ("G5-6e" "u-011e") ("G5-6f" "u-00cf")
    ("G5-70" "u-00cd") ("G5-71" "u-00cc") ("G5-72" "u-00ce")
    ("G5-73" "u-012a") ("G5-74" "u-00d1") ("G5-75" "u-00d1")
    ("G5-76" "u-00d6") ("G5-77" "u-00d3") ("G5-78" "u-00d2")
    ("G5-79" "u-00d4") ("G5-7a" "u-00d5") ("G5-7b" "u-014c")
    ("G5-7c" "u-00de") ("G5-7d" "u-0160") ("G5-7e" "u-0162")
    ("G5-80" "u-00dc") ("G5-81" "u-00da") ("G5-82" "u-00d9")
    ("G5-83" "u-00db") ("G5-84" "u-016a") ("G5-85" "u-016c")
    ("G5-86" "u-0178") ("G5-87" "u-00dd") ("G5-88" "u-017d")
    ("G5-89" "u-010c") ("G5-8a" "u-0106") ("G6-40" "j1-7576")
    ("G6-41" "j1-784f") ("G6-42" "j1-785d") ("G6-43" "j2-6f60")
    ("G6-44" "j1-7566") ("G6-45" "j1-7a65") ("G6-46" "j1-2f4a")
    ("G6-47" "j1-7556") ("G6-48" "z-0648") ("G6-49" "j1-7866")
    ("G6-4a" "j1-7562") ("G6-4b" "j1-2f53") ("G6-4c" "j1-785b")
    ("G6-4d" "j1-7752") ("G6-4e" "j1-7c43") ("G6-4f" "j1-2f5b")
    ("G6-50" "j1-7e40") ("G6-51" "j1-7721") ("G6-52" "j1-7a42")
    ("G6-53" "j1-7b34") ("G6-54" "j1-7e35") ("G6-55" "j1-7953")
    ("G6-56" "j1-7e36") ("G6-57" "z-0657") ("G6-58" "j2-7433")
    ("G6-59" "j1-7a75") ("G6-5a" "j2-2434") ("G6-5b" "j2-7345")
    ("G6-5c" "j2-7e74") ("G6-5d" "j1-7855") ("G6-5e" "j1-7c70")
    ("G6-5f" "j1-7831") ("G6-60" "j1-2e5f") ("G6-61" "j2-2336")
    ("G6-62" "j2-7b3d") ("G6-63" "j1-2f34") ("G6-64" "j2-776a")
    ("G6-65" "z-0665") ("G6-66" "j1-7857") ("G6-67" "j1-2f68")
    ("G6-68" "j2-7d4e") ("G6-69" "j2-7d38") ("G6-6a" "j1-7d51")
    ("G6-6b" "j1-7c73") ("G6-6c" "j2-2876") ("G6-6d" "j1-7925")
    ("G6-6e" "j1-792c") ("G6-6f" "j1-7540") ("G6-70" "z-0670")
    ("G6-71" "j1-2f31") ("G6-72" "j1-7768") ("G6-73" "j1-2f5f")
    ("G6-74" "j2-7e2c") ("G6-75" "j1-7830") ("G6-76" "j2-7c71")
    ("G6-77" "j2-7c7e") ("G6-78" "z-0678") ("G6-79" "j1-7654")
    ("G6-7a" "j2-6f5e") ("G6-7b" "j1-7c21") ("G6-7c" "j2-7430")
    ("G6-7d" "j2-7366") ("G6-7e" "j2-2358") ("G6-80" "z-0680")
    ("G6-81" "j1-7728") ("G6-82" "j1-7d62") ("G6-83" "j1-7d27")
    ("G6-84" "j1-7776") ("G6-85" "j2-772e") ("G6-86" "j1-7c5b")
    ("G6-87" "j1-2f79") ("G6-88" "j1-2f26") ("G6-89" "j1-7e48")
    ("G6-8a" "j2-7742") ("G6-8b" "j1-7c42") ("G6-8c" "j1-746b")
    ("G6-8d" "j1-794c") ("G6-8e" "j1-7e6d") ("G6-8f" "z-068f")
    ("G6-90" "j2-7e4a") ("G6-91" "z-0691") ("G6-92" "z-0692")
    ("G6-93" "j2-7b33") ("G6-94" "j1-7b75") ("G6-95" "j1-7a67")
    ("G6-96" "j2-793a") ("G6-97" "j1-773a") ("G6-98" "j2-716d")
    ("G6-99" "j2-7a3a") ("G6-9a" "j1-7656") ("G6-9b" "j2-7038")
    ("G6-9c" "j1-7728") ("G6-9d" "j1-7671") ("G6-9e" "j1-7648")
    ("G6-9f" "z-069f") ("G6-a0" "j1-7b2f") ("G9-27" "u-2019")
    ("G9-3d" "u-2018") ("G9-5c" "z-095c") ("G9-5e" "u-010c")
    ("G9-5f" "u-1e24") ("G9-60" "u-0141") ("G9-7b" "u-042f")
    ("G9-7c" "u-1e6c") ("G9-7d" "u-017d") ("G9-7e" "u-0101")
    ("G9-82" "u-0103") ("G9-83" "u-0105") ("G9-84" "u-0101")
    ("G9-85" "u-2026") ("G9-86" "h-0986") ("G9-87" "u-1e0d")
    ("G9-88" "u-0113") ("G9-89" "u-011b") ("G9-8a" "u-0119")
    ("G9-8b" "u-01e7") ("G9-8c" "u-011f") ("G9-91" "u-1e25")
    ("G9-92" "u-012b") ("G9-95" "u-0129") ("G9-96" "u-0142")
    ("G9-97" "u-0148") ("G9-98" "u-01d2") ("G9-99" "u-014d")
    ("G9-9a" "u-00f8") ("G9-9b" "u-0159") ("G9-9c" "u-0161")
    ("G9-9f" "u-015f") ("G9-a1" "u-1e63") ("G9-a2" "u-0163")
    ("G9-a4" "u-1e6d") ("G9-a5" "u-00b7") ("G9-a6" "u-0169")
    ("G9-a7" "u-016b") ("G9-a8" "u-016d") ("G9-a9" "u-016f")
    ("G9-aa" "h-09aa") ("G9-ab" "u-1e93") ("G9-ac" "u-017d")
    ("G9-ae" "u-00b0") ("G9-b2" "u-010d") ("G9-b3" "u-00b3")
    ("G9-b5" "u-00b5") ("G9-b8" "u-00b8") ("G9-b9" "u-00b9")
    ("G9-ba" "u-00ba") ("G9-bb" "u-00bb") ("G9-bc" "z-00bc")
    ("G9-bd" "z-00bd") ("G9-be" "u-0160") ("G9-bf" "u-00bf")
    ("G9-c0" "u-00c0") ("G9-c1" "u-00c1") ("G9-c2" "u-00c2")
    ("G9-c3" "u-00c3") ("G9-c4" "u-00c4") ("G9-c5" "u-00c5")
    ("G9-c6" "z-00c6") ("G9-c7" "u-00c7") ("G9-c8" "u-00c8")
    ("G9-c9" "u-00c9") ("G9-ca" "u-00ca") ("G9-cb" "u-00cb")
    ("G9-cc" "u-00cc") ("G9-cd" "u-00cd") ("G9-ce" "u-00ce")
    ("G9-cf" "u-00cf") ("G9-d0" "u-00d0") ("G9-d1" "u-00d1")
    ("G9-d2" "u-00d2") ("G9-d3" "u-00d3") ("G9-d4" "u-00d4")
    ("G9-d5" "u-00d5") ("G9-d6" "u-00d6") ("G9-d7" "u-00d7")
    ("G9-d8" "u-00d8") ("G9-d9" "u-00d9") ("G9-da" "u-00da")
    ("G9-db" "u-00db") ("G9-dc" "u-00dc") ("G9-dd" "u-00dd")
    ("G9-de" "u-00de") ("G9-df" "u-00df") ("G9-e0" "u-00e0")
    ("G9-e1" "u-00e1") ("G9-e2" "u-00e2") ("G9-e3" "u-00e3")
    ("G9-e4" "u-00e4") ("G9-e5" "u-00e5") ("G9-e6" "z-00e6")
    ("G9-e7" "u-00e7") ("G9-e8" "u-00e8") ("G9-e9" "u-00e9")
    ("G9-ea" "u-00ea") ("G9-eb" "u-00eb") ("G9-ec" "u-00ec")
    ("G9-ed" "u-00ed") ("G9-ee" "u-00ee") ("G9-ef" "u-00ef")
    ("G9-f0" "u-00f0") ("G9-f1" "u-00f1") ("G9-f2" "u-00f2")
    ("G9-f3" "u-00f3") ("G9-f4" "u-00f4") ("G9-f5" "u-00f5")
    ("G9-f6" "u-00f6") ("G9-f7" "u-00f7") ("G9-f8" "u-00f8")
    ("G9-f9" "u-00f9") ("G9-fa" "u-00fa") ("G9-fb" "u-00fb")
    ("G9-fc" "u-00fc") ("G9-fd" "u-00fd") ("G9-fe" "u-00fe")
    ("G9-ff" "u-00ff")
    ))

(defconst ndsrd-gaiji-table
  (lookup-new-gaiji-table
   '( 
     ("G2-20" " ") ("G4-20" " ") ("G9-20" " ") ("G3-20" " ")
     ("G5-20" " ") ("G1-20" " ") ("G0-20" " ") ("G0-60" "`")
     ("G9-b4" "$B!-(B") ("G0-88" "^") ("G0-5e" "^") ("G0-5f" "_")
     ("G0-2d" "-") ("G5-2d" "-") ("G3-2d" "-") ("G9-2d" "-")
     ("G0-96" "-") ("G9-ad" "-") ("G4-2d" "-") ("G2-2d" "-")
     ("G1-b8" "-") ("G1-2d" "-") ("G0-95" "$B!&(B") ("G3-2c" ",")
     ("G0-82" ",") ("G5-2c" ",") ("G9-2c" ",") ("G4-2c" ",")
     ("G2-2c" ",") ("G1-2c" ",") ("G0-2c" ",") ("G9-3b" ";")
     ("G0-3b" ";") ("G2-3b" ";") ("G1-3b" ";") ("G3-3b" ";")
     ("G5-3b" ";") ("G4-3b" ";") ("G9-3a" ":") ("G5-3a" ":")
     ("G0-3a" ":") ("G3-3a" ":") ("G4-3a" ":") ("G1-3a" ":")
     ("G2-3a" ":") ("G4-21" "!")  ("G3-21" "!")  ("G9-21" "!")
     ("G2-21" "!")  ("G5-21" "!")  ("G0-21" "!")  ("G1-21" "!")
     ("G5-3f" "?")  ("G0-3f" "?")  ("G9-3f" "?")  ("G2-3f" "?")
     ("G1-3f" "?")  ("G4-3f" "?")  ("G3-3f" "?")  ("G0-2e" ".")
     ("G3-2e" ".")  ("G4-2e" ".")  ("G2-2e" ".")  ("G5-2e" ".")
     ("G9-2e" ".")  ("G1-2e" ".")  ("G3-22" "\"") ("G1-22" "\"")
     ("G4-22" "\"") ("G5-22" "\"") ("G2-22" "\"") ("G0-22" "\"")
     ("G0-91" "$B!F(B") ("G0-92" "$B!G(B") ("G0-93" "$B!H(B") ("G9-93" "$B!H(B")
     ("G0-94" "$B!I(B") ("G9-94" "$B!I(B") ("G5-28" "(") ("G4-28" "(")
     ("G3-28" "(") ("G1-28" "(") ("G2-28" "(") ("G9-28" "(")
     ("G0-28" "(") ("G9-29" ")") ("G0-29" ")") ("G3-29" ")")
     ("G1-29" ")") ("G5-29" ")") ("G2-29" ")") ("G4-29" ")")
     ("G9-5b" "[") ("G0-5b" "[") ("G9-5d" "]") ("G0-5d" "]")
     ("G0-7b" "{") ("G0-7d" "}") ("G0-b6" "$B"y(B") ("G9-b6" "$B"y(B")
     ("G0-40" "@") ("G1-40" "@") ("G9-40" "@") ("G2-2a" "*")
     ("G9-2a" "*") ("G4-2a" "*") ("G1-2a" "*") ("G0-2a" "*")
     ("G3-2a" "*") ("G5-2a" "*") ("G9-2f" "/") ("G0-2f" "/")
     ("G2-2f" "/") ("G4-2f" "/") ("G3-2f" "/") ("G1-2f" "/")
     ("G5-2f" "/") ("G0-5c" "\\") ("G5-26" "&") ("G9-26" "&")
     ("G2-26" "&") ("G1-26" "&") ("G3-26" "&") ("G0-26" "&")
     ("G4-26" "&") ("G0-23" "#") ("G4-23" "#") ("G1-23" "#")
     ("G2-23" "#") ("G5-23" "#") ("G3-23" "#") ("G9-25" "%")
     ("G3-25" "%") ("G1-25" "%") ("G0-25" "%") ("G4-25" "%")
     ("G5-25" "%") ("G2-25" "%") ("G0-89" "$B"s(B") ("G9-af" "$B!m(B")
     ("G5-2b" "+") ("G0-2b" "+") ("G3-2b" "+") ("G1-2b" "+")
     ("G4-2b" "+") ("G2-2b" "+") ("G9-2b" "+") ("G0-3c" "<")
     ("G5-3c" "<") ("G2-3c" "<") ("G1-3c" "<") ("G4-3c" "<")
     ("G3-3c" "<") ("G9-3c" "<") ("G2-3d" "=") ("G4-3d" "=")
     ("G1-3d" "=") ("G5-3d" "=") ("G0-3d" "=") ("G3-3d" "=")
     ("G2-3e" ">") ("G9-3e" ">") ("G5-3e" ">") ("G1-3e" ">")
     ("G3-3e" ">") ("G4-3e" ">") ("G0-3e" ">") ("G0-7c" "|")
     ("G0-98" "~") ("G0-7e" "~") ("G4-6c" "$B"e(B") ("G9-24" "$")
     ("G0-24" "$") ("G3-24" "$") ("G1-24" "$") ("G5-24" "$")
     ("G4-24" "$") ("G2-24" "$") ("G9-a3" "$B!r(B") ("G0-a3" "$B!r(B")
     ("G9-b7" "$B!o(B") ("G0-a5" "$B!o(B") ("G3-30" "0") ("G2-30" "0")
     ("G0-30" "0") ("G4-30" "0") ("G5-30" "0") ("G1-30" "0")
     ("G9-30" "0") ("G9-31" "1") ("G2-31" "1") ("G1-31" "1")
     ("G4-31" "1") ("G3-31" "1") ("G0-31" "1") ("G5-31" "1")
     ("G1-32" "2") ("G0-32" "2") ("G5-32" "2") ("G9-32" "2")
     ("G3-32" "2") ("G4-32" "2") ("G2-32" "2") ("G4-33" "3")
     ("G5-33" "3") ("G0-33" "3") ("G2-33" "3") ("G9-33" "3")
     ("G3-33" "3") ("G1-33" "3") ("G3-34" "4") ("G4-34" "4")
     ("G2-34" "4") ("G1-34" "4") ("G9-34" "4") ("G5-34" "4")
     ("G0-34" "4") ("G9-35" "5") ("G4-35" "5") ("G5-35" "5")
     ("G1-35" "5") ("G3-35" "5") ("G2-35" "5") ("G0-35" "5")
     ("G1-36" "6") ("G3-36" "6") ("G4-36" "6") ("G5-36" "6")
     ("G0-36" "6") ("G2-36" "6") ("G9-36" "6") ("G0-37" "7")
     ("G5-37" "7") ("G4-37" "7") ("G9-37" "7") ("G1-37" "7")
     ("G3-37" "7") ("G2-37" "7") ("G0-38" "8") ("G5-38" "8")
     ("G1-38" "8") ("G9-38" "8") ("G2-38" "8") ("G3-38" "8")
     ("G4-38" "8") ("G1-39" "9") ("G0-39" "9") ("G5-39" "9")
     ("G4-39" "9") ("G2-39" "9") ("G3-39" "9") ("G9-39" "9")
     ("G5-41" "A") ("G0-61" "a") ("G9-41" "A") ("G9-61" "a")
     ("G0-41" "A") ("G9-42" "B") ("G5-42" "B") ("G9-62" "b")
     ("G0-42" "B") ("G0-62" "b") ("G0-63" "c") ("G0-43" "C")
     ("G9-43" "C") ("G9-63" "c") ("G5-43" "C") ("G5-44" "D")
     ("G9-64" "d") ("G0-64" "d") ("G0-44" "D") ("G9-44" "D")
     ("G0-65" "e") ("G9-45" "E") ("G0-45" "E") ("G5-45" "E")
     ("G9-65" "e") ("G9-46" "F") ("G0-46" "F") ("G5-46" "F")
     ("G0-66" "f") ("G9-66" "f") ("G0-47" "G") ("G9-67" "g")
     ("G5-47" "G") ("G0-67" "g") ("G9-47" "G") ("G0-48" "H")
     ("G0-68" "h") ("G9-68" "h") ("G5-48" "H") ("G9-48" "H")
     ("G9-69" "i") ("G5-49" "I") ("G9-49" "I") ("G0-69" "i")
     ("G0-49" "I") ("G9-6a" "j") ("G9-4a" "J") ("G0-4a" "J")
     ("G0-6a" "j") ("G5-4a" "J") ("G0-4b" "K") ("G5-4b" "K")
     ("G0-6b" "k") ("G9-6b" "k") ("G9-4b" "K") ("G0-6c" "l")
     ("G9-6c" "l") ("G0-4c" "L") ("G5-4c" "L") ("G9-4c" "L")
     ("G5-4d" "M") ("G0-4d" "M") ("G0-6d" "m") ("G9-6d" "m")
     ("G9-4d" "M") ("G9-6e" "n") ("G0-6e" "n") ("G5-4e" "N")
     ("G0-4e" "N") ("G9-4e" "N") ("G0-6f" "o") ("G0-4f" "O")
     ("G9-4f" "O") ("G9-6f" "o") ("G5-4f" "O") ("G0-50" "P")
     ("G9-50" "P") ("G9-70" "p") ("G0-70" "p") ("G5-50" "P")
     ("G5-51" "Q") ("G9-51" "Q") ("G0-51" "Q") ("G0-71" "q")
     ("G9-71" "q") ("G4-81" "R") ("G0-72" "r") ("G9-72" "r")
     ("G0-52" "R") ("G9-52" "R") ("G5-52" "R") ("G9-73" "s")
     ("G5-53" "S") ("G9-53" "S") ("G0-53" "S") ("G0-73" "s")
     ("G4-82" "S") ("G9-74" "t") ("G9-54" "T") ("G0-74" "t")
     ("G5-54" "T") ("G0-54" "T") ("G4-83" "T") ("G0-55" "U")
     ("G9-55" "U") ("G0-75" "u") ("G9-75" "u") ("G4-84" "U")
     ("G5-55" "U") ("G0-76" "v") ("G0-56" "V") ("G4-85" "V")
     ("G9-76" "v") ("G5-56" "V") ("G9-56" "V") ("G5-57" "W")
     ("G9-57" "W") ("G9-77" "w") ("G0-57" "W") ("G0-77" "w")
     ("G9-78" "x") ("G0-58" "X") ("G9-58" "X") ("G0-78" "x")
     ("G4-86" "X") ("G5-58" "X") ("G9-79" "y") ("G5-59" "Y")
     ("G0-79" "y") ("G9-59" "Y") ("G4-87" "Y") ("G0-59" "Y")
     ("G0-7a" "z") ("G5-5a" "Z") ("G9-5a" "Z") ("G0-5a" "Z")
     ("G9-7a" "z") ("G9-22" "$B&C(B") ("G9-b0" "$B&H(B") ("G9-b1" "$B&V(B")
     ("G9-23" "$B&8(B")

     ("G0-83" nil "#f") ("G0-85" nil "...") ("G0-8a" nil "SV")
     ("G0-8c" nil "OE") ("G0-9c" nil "oe") ("G0-a9" nil "(C)")
     ("G0-ae" nil "(R)") ("G0-b0" nil "$B!k(B") ("G0-b4" nil "$B!l(B")
     ("G0-b5" nil "$B&L(B") ("G0-b7" nil "$B!&(B") ("G0-b8" nil ",")
     ("G0-bc" nil "1/4") ("G0-bd" nil "1/2") ("G0-be" nil "3/4")
     ("G0-bf" nil "??") ("G0-c0" nil "A$B!.(B") ("G0-c1" nil "A$B!-(B")
     ("G0-c2" nil "A^") ("G0-c4" nil "A$B!/(B") ("G0-c5" nil "A$B!k(B")
     ("G0-c6" nil "AE") ("G0-c7" nil "C,") ("G0-c8" nil "E$B!.(B")
     ("G0-c9" nil "E$B!-(B") ("G0-ca" nil "E^") ("G0-cc" nil "I$B!.(B")
     ("G0-cd" nil "I$B!-(B") ("G0-ce" nil "I^") ("G0-d0" nil "D-")
     ("G0-d2" nil "O$B!.(B") ("G0-d3" nil "O$B!-(B") ("G0-d6" nil "O$B!/(B")
     ("G0-d9" nil "U$B!.(B") ("G0-da" nil "U$B!-(B") ("G0-dc" nil "U$B!/(B")
     ("G0-dd" nil "Y$B!-(B") ("G0-df" nil "SZ") ("G0-e0" nil "a$B!.(B")
     ("G0-e1" nil "a$B!-(B") ("G0-e2" nil "a^") ("G0-e3" nil "a~")
     ("G0-e4" nil "a$B!/(B") ("G0-e5" nil "a$B!k(B") ("G0-e6" nil "#ae")
     ("G0-e7" nil "c,") ("G0-e8" nil "e$B!.(B") ("G0-e9" nil "e$B!-(B")
     ("G0-ea" nil "e^") ("G0-eb" nil "e$B!/(B") ("G0-ec" nil "i$B!.(B")
     ("G0-ed" nil "i$B!-(B") ("G0-ee" nil "i^") ("G0-ef" nil "i$B!/(B")
     ("G0-f0" nil "#d") ("G0-f1" nil "n~") ("G0-f2" nil "o$B!.(B")
     ("G0-f3" nil "o$B!-(B") ("G0-f4" nil "o^") ("G0-f5" nil "o~")
     ("G0-f6" nil "o$B!/(B") ("G0-f9" nil "u$B!.(B") ("G0-fa" nil "u$B!-(B")
     ("G0-fb" nil "u^") ("G0-fc" nil "u$B!/(B") ("G0-fd" nil "y$B!-(B")
     ("G0-fe" nil "#y") ("G0-ff" nil "y$B!/(B") ("G1-41" nil "#a")
     ("G1-42" nil "#O") ("G1-43" nil "#A$B!-(B") ("G1-4a" nil "#ae$B!-(B")
     ("G1-4b" nil "#ae$B!.(B") ("G1-4c" nil "#e$B!-(B") ("G1-4d" nil "#e$B!.(B")
     ("G1-4e" nil "#a$B!-(B") ("G1-4f" nil "#a$B!.(B") ("G1-50" nil "#S")
     ("G1-51" nil "#O$B!-(B") ("G1-52" nil "#O$B!.(B") ("G1-53" nil "#E$B!-(B")
     ("G1-54" nil "#E$B!.(B") ("G1-57" nil "ae$B!1(B") ("G1-58" nil "e$B!1(B")
     ("G1-59" nil "i$B!1(B") ("G1-5a" nil "u$B!1(B") ("G1-5b" nil "o$B!1(B")
     ("G1-5c" nil "a$B!1(B") ("G1-5d" nil "A$B!1(B") ("G1-5e" nil "y$B!1(B")
     ("G1-5f" nil "N$B!1(B") ("G1-60" nil "r$B!1(B") ("G1-61" nil "#a?")
     ("G1-62" nil "i-$B!-(B") ("G1-63" nil "i-") ("G1-64" nil "d-")
     ("G1-65" nil "#a~") ("G1-66" nil "O$B!1(B") ("G1-67" nil "n$B!1(B")
     ("G1-68" nil "U$B!1(B") ("G1-6a" nil "#t") ("G1-71" nil "-$B!-(B")
     ("G1-72" nil "-$B!.(B") ("G1-73" nil "#g") ("G1-76" nil "#ng")
     ("G1-78" nil "r$B!.(B") ("G1-7a" nil "y$B!.(B") ("G1-7d" nil "o/$B!-(B")
     ("G1-7e" nil "o/$B!.(B") ("G1-80" nil "E$B!1(B") ("G1-81" nil "I$B!1(B")
     ("G1-86" nil "#E") ("G1-88" nil "Y$B!.(B") ("G1-89" nil "#jn")
     ("G1-8a" nil "a$B!1(B") ("G1-8b" nil "B$B!.(B") ("G1-8c" nil "C$B!-(B")
     ("G1-92" nil "i~") ("G1-93" nil "i^") ("G1-94" nil "O^")
     ("G1-95" nil "aU") ("G1-96" nil "gU") ("G1-97" nil "iU")
     ("G1-98" nil "eU") ("G1-99" nil "uU") ("G1-9a" nil "oU")
     ("G1-9b" nil "sU") ("G1-9c" nil "cU") ("G1-9d" nil "y^")
     ("G1-9e" nil "g^") ("G1-9f" nil "#a$B!1(B") ("G1-a0" nil "p$B!1(B")
     ("G1-a3" nil "w^") ("G1-a5" nil "w$B!1(B") ("G1-a6" nil "x$B!1(B")
     ("G1-a7" nil "X$B!-(B") ("G1-a8" nil "c$B!1(B") ("G1-a9" nil "a?")
     ("G1-ac" nil "yU") ("G1-ae" nil "aU") ("G1-b4" nil "#v")
     ("G1-b6" nil "z.") ("G1-b7" nil "$B".(B") ("G1-b9" nil "d_")
     ("G1-ba" nil "r_") ("G1-bc" nil "i/") ("G1-c1" nil "u~")
     ("G1-c3" nil "y?") ("G1-c4" nil "m.") ("G1-c5" nil "n.")
     ("G1-c6" nil "e.") ("G1-c7" nil "Z.") ("G1-cd" nil "l..")
     ("G1-ce" nil "r..") ("G1-cf" nil "rV") ("G1-d0" nil "jV")
     ("G1-d2" nil "eV") ("G1-d3" nil "sV") ("G1-d4" nil "aV")
     ("G1-d5" nil "cV") ("G1-d6" nil "iV") ("G1-d7" nil "CV")
     ("G1-d8" nil "nV") ("G1-e1" nil "($B%?%V!<(B)") ("G1-e5" nil "e$B!1!-(B")
     ("G1-e6" nil "$B"'(B") ("G1-eb" nil "s$B!-(B") ("G1-ec" nil "i.$B!-(B")
     ("G1-ed" nil "#Q") ("G1-ee" nil "r$B!-(B") ("G1-ef" nil "k$B!-(B")
     ("G1-f2" nil "s.") ("G1-f4" nil "#a$B!1!-(B") ("G1-f5" nil "i$B!1!-(B")
     ("G1-f6" nil "e$B!1!-(B") ("G1-f7" nil "u$B!1!-(B") ("G1-fc" nil "o~$B!-(B")
     ("G2-40" nil "L/") ("G2-43" nil "l/") ("G2-44" nil "l$B!A(B")
     ("G2-48" nil "#n") ("G2-49" nil "oe$B!-(B") ("G2-4a" nil "oe$B!.(B")
     ("G2-4b" nil "#i/") ("G2-52" nil "aa$B!1(B") ("G2-54" nil "#M")
     ("G2-55" nil "s,") ("G2-5f" nil "t,") ("G2-62" nil "H.")
     ("G2-63" nil "h.") ("G2-64" nil "Px") ("G2-65" nil "oV")
     ("G2-66" nil "t.") ("G2-67" nil "[$B%?%$(B]") ("G2-67" nil "[$B%?%$(B]")
     ("G2-75" nil "#a$B!H(B") ("G2-79" nil "d.") ("G2-7a" nil "s$B!#(B")
     ("G2-7c" nil "D.") ("G2-7d" nil "o/") ("G2-81" nil "[$B%@%k%;!<%K%g(B]")
     ("G2-8a" nil "aC") ("G2-8d" nil "[$B%@%V%k%7%c!<%W(B]") ("G2-95" nil "E|")
     ("G2-97" nil "h-") ("G2-98" nil "d$B!#(B") ("G2-9e" nil "[$B%U%'%k%^!<%?(B]")
     ("G2-9f" nil "[$B5U%U%'%k%^!<%?(B]") ("G2-a1" nil "[$B"*(B]") ("G2-ab" nil "b$B!#(B")
     ("G2-af" nil "[10^10^100]") ("G2-b4" nil "R?") ("G2-b5" nil "f?")
     ("G2-b8" nil "#V") ("G2-bd" nil "m$B!#(B") ("G2-be" nil "o.")
     ("G2-c2" nil "i$B!/!-(B") ("G2-c6" nil "z$B!.(B") ("G2-c8" nil "Q$B!.(B")
     ("G2-c9" nil "[16$BJ,2;Id(B]") ("G2-cb" nil "u$B!H(B") ("G2-cc" nil "#'")
     ("G2-cd" nil "[$B%k!<%H(B-1]") ("G2-ce" nil "T.") ("G2-cf" nil "[n$B>h:,(B]")
     ("G2-d0" nil "!?") ("G2-e1" nil "#A$B!.(B") ("G2-e4" nil "$B"'(B")
     ("G2-e9" nil "z$B!-(B") ("G2-eb" nil "m$B!.(B") ("G2-f0" nil "p$B!.(B")
     ("G2-f1" nil "#12") ("G2-f9" nil "[$B%b!<(B]") ("G2-fb" nil "M$B!1(B")
     ("G3-40" nil "w~") ("G3-41" nil "z.") ("G3-44" nil "[$B%J%A%e%i%k(B]")
     ("G3-45" nil "e.$B!-(B") ("G3-46" nil "i/$B!-(B") ("G3-4f" nil "[$B",(B]")
     ("G3-50" nil "[$B"-(B]") ("G3-52" nil "(P)") ("G3-5f" nil "a?~$B!-(B")
     ("G3-63" nil "e$B!1!.(B") ("G3-66" nil "zV") ("G3-67" nil "e~$B!-(B")
     ("G3-69" nil "i$B!1!-(B") ("G3-75" nil "S$B!-(B") ("G3-76" nil "#O~$B!-(B")
     ("G3-77" nil "#A") ("G3-79" nil "S.") ("G3-84" nil "[a+b$B!1(B]")
     ("G3-88" nil "i$B!H(B") ("G3-89" nil "e^.") ("G3-8a" nil "$B".(B")
     ("G3-8c" nil "gV") ("G3-8d" nil "[$B%k!<%H(B2Rr]") ("G3-91" nil "l.")
     ("G3-9a" nil "#R") ("G3-9b" nil "t?") ("G3-9c" nil "#i$B!1(B")
     ("G3-9d" nil "#A~$B!-(B") ("G3-9f" nil "u-$B!-(B") ("G3-a0" nil "A?")
     ("G3-a3" nil "o^.") ("G3-a4" nil "#a^.") ("G3-a8" nil "o$B!-(B")
     ("G3-aa" nil "#ye1") ("G3-ab" nil "#ye2") ("G3-b9" nil "#e")
     ("G3-ba" nil "$B"+"*(B") ("G3-bc" nil "$B&A!-(B") ("G3-bd" nil "n.")
     ("G3-be" nil "r.") ("G3-bf" nil "p.") ("G3-c1" nil "#E~")
     ("G3-c2" nil "b.") ("G3-c3" nil "k.") ("G3-c4" nil "c$B!-(B")
     ("G3-c5" nil "m.") ("G3-c6" nil "e.") ("G3-ca" nil "D$B!-(B")
     ("G3-cb" nil "T$B!-(B") ("G3-cc" nil "P$B!.(B") ("G3-cd" nil "R$B!-(B")
     ("G3-ce" nil "N$B!.(B") ("G3-cf" nil "#a$B!1!-(B") ("G3-d3" nil "g$B!-(B")
     ("G3-d4" nil "Q$B!-(B") ("G3-d5" nil "s$B!1!-(B") ("G3-d6" nil "M$B!.(B")
     ("G3-d7" nil "P$B!-(B") ("G3-d8" nil "y$B!1!-(B") ("G3-d9" nil "V$B!-(B")
     ("G3-da" nil "N$B!-(B") ("G3-db" nil "B$B!-(B") ("G3-dc" nil "H$B!-(B")
     ("G3-dd" nil "J$B!-(B") ("G3-de" nil "M$B!-(B") ("G3-e1" nil "a?$B!-(B")
     ("G3-e5" nil "k.") ("G3-e6" nil "#a.") ("G3-e7" nil "2$B!.(B")
     ("G3-e8" nil "1$B!-(B") ("G3-e9" nil "F$B!-(B") ("G3-ea" nil "K$B!-(B")
     ("G3-eb" nil "7$B!-(B") ("G3-ec" nil "L$B!-(B") ("G3-ed" nil "W$B!-(B")
     ("G3-ee" nil "o.$B!-(B") ("G3-ef" nil "2$B!-(B") ("G3-f0" nil "3$B!-(B")
     ("G3-f1" nil "9$B!-(B") ("G3-f3" nil "4$B!-(B") ("G3-f4" nil "#a.$B!-(B")
     ("G3-f6" nil "6$B!-(B") ("G3-f7" nil "8$B!-(B") ("G3-f9" nil "t$B!-(B")
     ("G3-fa" nil "x$B!-(B") ("G3-fb" nil "m$B!-(B") ("G4-0f" nil "$B!T(B")
     ("G4-40" nil "q$B!.(B") ("G4-41" nil "x$B!.(B") ("G4-42" nil "C$B!.(B")
     ("G4-43" nil "Z$B!.(B") ("G4-44" nil "ZV") ("G4-45" nil "V$B!.(B")
     ("G4-46" nil "T$B!.(B") ("G4-47" nil "G$B!.(B") ("G4-48" nil "J$B!.(B")
     ("G4-49" nil "K$B!.(B") ("G4-4a" nil "F$B!.(B") ("G4-4b" nil "I$B!.(B")
     ("G4-4c" nil "Z$B!-(B") ("G4-4d" nil "L$B!.(B") ("G4-4e" nil "p$B!-(B")
     ("G4-4f" nil "D$B!.(B") ("G4-50" nil "S$B!.(B") ("G4-51" nil "R$B!.(B")
     ("G4-52" nil "b$B!-(B") ("G4-53" nil "H$B!.(B") ("G4-54" nil "W$B!.(B")
     ("G4-56" nil "#e$B!/(B") ("G4-57" nil "G$B!-(B") ("G4-59" nil "n$B!-(B")
     ("G4-5b" nil "d$B!-(B") ("G4-5c" nil "#o~") ("G4-5e" nil "a?~")
     ("G4-5f" nil "f$B!-(B") ("G4-60" nil "i") ("G4-61" nil "oe~")
     ("G4-62" nil "ae~") ("G4-64" nil "Cg~") ("G4-66" nil "h^")
     ("G4-67" nil "u.") ("G4-6f" nil "#kw")
     ("G4-72" nil "[s(s-a)(s-b)(s-c)$B$NJ?J}:,(B]") ("G4-77" nil ":")
     ("G4-79" nil "#i.") ("G4-88" nil "$B"*(B") ("G4-89" nil "$B"*(B")
     ("G4-8a" nil "[$B%k!<%H(B2]") ("G4-8b" nil "[Et]") ("G4-8e" nil "1/3")
     ("G4-90" nil "1/8") ("G4-91" nil "3/8") ("G4-92" nil "5/8")
     ("G4-93" nil "7/8") ("G4-95" nil "3/16") ("G4-96" nil "7/16")
     ("G4-97" nil "5/10") ("G4-98" nil "11/32") ("G4-99" nil "2/5")
     ("G4-9a" nil "2/3") ("G4-9b" nil "$B"+(B") ("G4-9d" nil "$B"*(B")
     ("G4-9f" nil "$B!T(B") ("G4-a0" nil "$B!U(B") ("G4-a1" nil "$B!L(B")
     ("G4-a2" nil "$B!M(B") ("G5-5d" nil "O/") ("G5-60" nil "A$B!.(B")
     ("G5-61" nil "A^") ("G5-6a" nil "E") ("G5-70" nil "I$B!-(B")
     ("G5-75" nil "N~") ("G5-76" nil "O$B!/(B") ("G5-80" nil "U$B!/(B")
     ("G5-81" nil "U$B!-(B") ("G5-83" nil "U$B!.(B") ("G5-84" nil "U^")
     ("G5-85" nil "U$B!1(B") ("G5-88" nil "ZV") ("G5-89" nil "CV")
     ("G5-8a" nil "C$B!-(B") ("G6-40" nil "[$BLZH}(B]") ("G6-41" nil "[$BIB(B-$BJ:(B+$B:A(B]")
     ("G6-42" nil "[$BIB(B-$BJ:(B+$B1E(B]") ("G6-43" nil "[$B2P@P(B]") ("G6-44" nil "[$BLZV*(B]")
     ("G6-45" nil "[$Bgg;T(B]") ("G6-46" nil "[$BEZ[4(B]") ("G6-47" nil "[$BLZFb(B]")
     ("G6-48" nil "[$BLZ6}(B]") ("G6-49" nil "[$B::Hi(B]") ("G6-4a" nil "[$BLZ>e2<(B]")
     ("G6-4b" nil "[$BEZ?b(B]") ("G6-4c" nil "[$BIB(B-$BJ:(B+$B@a(B]")
     ("G6-4d" nil "[$B2P(B+$B2K(B-$BF|(B]") ("G6-4e" nil "[$BB-IU(B]") ("G6-4f" nil "[$BEZ@l(B]")
     ("G6-50" nil "[$B5{F~(B]") ("G6-51" nil "[$B?ebC(B]") ("G6-52" nil "[$BM;(B-$BCn(B+$B1)(B]")
     ("G6-53" nil "[$BggUd(B]") ("G6-54" nil "[$B9|(B+$BDc(B-$B?M(B]") ("G6-55" nil "[$B7j2L(B]")
     ("G6-56" nil "[$B9|2L(B]") ("G6-57" nil "[$B;D(B+$B1](B-$B;7(B]") ("G6-58" nil "[$B;e6g(B]")
     ("G6-59" nil "[$BggBE(B]") ("G6-5a" nil "[$B8}AG(B]") ("G6-5b" nil "[$BC]E[(B]")
     ("G6-5c" nil "[$B;u@N(B]") ("G6-5d" nil "[$BIB(B-$BJ:(B+$BGB(B]") ("G6-5e" nil "[$BEPEa(B]")
     ("G6-5f" nil "[$B2&(B+$B0N(B-$B?M(B]") ("G6-60" nil "[$BXyXyEa(B]") ("G6-61" nil "[$BXyEa(B]")
     ("G6-62" nil "[$B6bDL(B]") ("G6-63" nil "[$B8}3k(B]") ("G6-64" nil "[$BCn(B+$B0n(B-$B?e(B]")
     ("G6-65" nil "[$B%N5n(B]") ("G6-66" nil "[$BIB(B-$BJ:(B+$BI<(B]") ("G6-67" nil "[U8641]")
     ("G6-68" nil "[$B5{LH(B]") ("G6-69" nil "[$BH1(B-$BM'(B+$BfM(B]") ("G6-6a" nil "[$BLgCn(B]")
     ("G6-6b" nil "[$B6H(B+$B9Y(B-$B8r(B]") ("G6-6c" nil "[$BK.6R(B]") ("G6-6d" nil "[$B@P<V(B]")
     ("G6-6e" nil "[$B@P5t(B]") ("G6-6f" nil "[$BF|Rk(B]") ("G6-70" nil "[$BJ}(B+$BN.(B-$B?e(B]")
     ("G6-71" nil "[$B8}X~(B]") ("G6-72" nil "[U729B]") ("G6-73" nil "[$BEZFX(B]")
     ("G6-74" nil "[$B;]D;(B]") ("G6-75" nil "[$B2&FG(B]") ("G6-76" nil "[$BGO(B+$B7m(B-$B8@(B]")
     ("G6-77" nil "[$BGO@'(B]") ("G6-78" nil "[$Bl*(B-$B8@(B+$B1;(B]") ("G6-79" nil "[$B?eRF(B]")
     ("G6-7a" nil "[$B2PP6(B]") ("G6-7b" nil "[$B8@6T(B]") ("G6-7c" nil "[$B;e(B+$B<X(B-$BCn(B]")
     ("G6-7d" nil "[$BC]A<(B]") ("G6-7e" nil "[$B1^9C(B]") ("G6-80" nil "[$BB-?_(B]")
     ("G6-81" nil "[$B?e>O(B]") ("G6-82" nil "[$Bl0(B+$B2m(B-$Bl.(B]") ("G6-83" nil "[$B6bHi(B]")
     ("G6-84" nil "[$B2&J,(B]") ("G6-85" nil "[$BggKa(B]") ("G6-86" nil "[$B:R(B-$B2P(B+$BM8(B")
     ("G6-87" nil "[$B=w(B+$B12(B-$B?e(B]") ("G6-88" nil "[$B8}1b(B]") ("G6-89" nil "[$B5{<)(B]")
     ("G6-8a" nil "[$BCn2g(B]") ("G6-8b" nil "[$BB-Jq(B]") ("G6-8c" nil "[$B<j(B+$BJ;(B-$B?M(B]")
     ("G6-8d" nil "[$B2S(B+$BIb(B-$B?e(B]") ("G6-8e" nil "[$BsO(B-$BIW(B+$BHi(B]")
     ("G6-8f" nil "[$B?3(B+$B9Y(B+$B8r(B]") ("G6-90" nil "[$B4WD;(B]") ("G6-91" nil "[$B1)@'(B]")
     ("G6-92" nil "[$BLZ:s(B]") ("G6-93" nil "[$B6b(B+$BD3(B-$BCn(B]") ("G6-94" nil "[$B0a8K(B]")
     ("G6-95" nil "[$Bgg@Z(B]") ("G6-96" nil "[$BB-Bf(B]") ("G6-97" nil "[$B?e0](B]")
     ("G6-98" nil "[$BIB(B-$BJ:(B+$B1#(B]") ("G6-99" nil "[$B6P(B+$B9Y(B-$B8z(B]")
     ("G6-9a" nil "[$B?e85(B]") ("G6-9b" nil "[$BIu5m(B]") ("G6-9c" nil "[$B?e>O(B]")
     ("G6-9d" nil "[$B?e(B+$BrK(B-$B5{(B]") ("G6-9e" nil "[$B;D(B+$B3`(B-$B;7(B]")
     ("G6-9f" nil "[$B%O!&(B]") ("G9-23" nil "#") ("G9-3d" nil "$B!F(B")
     ("G9-5c" nil "[aa$B!1(B]") ("G9-5e" nil "CV") ("G9-5f" nil "H.")
     ("G9-60" nil "L/") ("G9-7b" nil "#R") ("G9-7c" nil "T.")
     ("G9-7d" nil "ZV") ("G9-7e" nil "a$B!1(B") ("G9-82" nil "aU")
     ("G9-83" nil "aC") ("G9-85" nil "...") ("G9-86" nil "c") ("G9-87" nil "d")
     ("G9-88" nil "e$B!1(B") ("G9-89" nil "eV") ("G9-8a" nil "eC")
     ("G9-8b" nil "gV") ("G9-8c" nil "gU") ("G9-91" nil "h.")
     ("G9-92" nil "i$B!1(B") ("G9-95" nil "i~") ("G9-96" nil "l/")
     ("G9-97" nil "nV") ("G9-98" nil "oV") ("G9-99" nil "o$B!1(B")
     ("G9-9a" nil "o/") ("G9-9b" nil "rV") ("G9-9c" nil "sV")
     ("G9-9f" nil "s,") ("G9-a1" nil "s.") ("G9-a2" nil "t,")
     ("G9-a4" nil "t.") ("G9-a6" nil "u~") ("G9-a7" nil "u$B!1(B")
     ("G9-a8" nil "uU") ("G9-a9" nil "u$B!k(B") ("G9-aa" nil "u$B!1!-(B")
     ("G9-ab" nil "z.") ("G9-ac" nil "zV") ("G9-ae" nil "$B!k(B")
     ("G9-b2" nil "cV") ("G9-bd" nil "1/2") ("G9-be" nil "SV")
     ("G9-bf" nil "??") ("G9-c0" nil "A$B!.(B") ("G9-c1" nil "A$B!-(B")
     ("G9-c5" nil "A$B!k(B") ("G9-c6" nil "AE") ("G9-c7" nil "C,")
     ("G9-c8" nil "E$B!.(B") ("G9-c9" nil "E$B!-(B") ("G9-cc" nil "I$B!.(B")
     ("G9-cd" nil "I$B!-(B") ("G9-ce" nil "I^") ("G9-d2" nil "O$B!.(B")
     ("G9-d3" nil "O$B!-(B") ("G9-d6" nil "O$B!/(B") ("G9-d7" nil "$B!_(B")
     ("G9-d9" nil "U$B!.(B") ("G9-da" nil "U$B!-(B") ("G9-dc" nil "U$B!/(B")
     ("G9-dd" nil "Y$B!-(B") ("G9-df" nil "SZ") ("G9-e0" nil "a$B!.(B")
     ("G9-e1" nil "a$B!-(B") ("G9-e2" nil "a^") ("G9-e3" nil "a~")
     ("G9-e4" nil "a$B!/(B") ("G9-e5" nil "a$B!k(B") ("G9-e6" nil "ae")
     ("G9-e7" nil "c,") ("G9-e8" nil "e$B!.(B") ("G9-e9" nil "e$B!-(B")
     ("G9-ea" nil "e^") ("G9-eb" nil "e$B!/(B") ("G9-ec" nil "i$B!.(B")
     ("G9-ed" nil "i$B!-(B") ("G9-ee" nil "i^") ("G9-ef" nil "i$B!/(B")
     ("G9-f1" nil "n~") ("G9-f2" nil "o$B!.(B") ("G9-f3" nil "o$B!-(B")
     ("G9-f4" nil "o^") ("G9-f5" nil "o~") ("G9-f6" nil "o$B!/(B")
     ("G9-f9" nil "u$B!.(B") ("G9-fa" nil "u$B!-(B") ("G9-fb" nil "u^")
     ("G9-fc" nil "u$B!/(B") ("G9-fd" nil "y$B!-(B") ("G9-ff" nil "y$B!/(B")
     )))

(defconst ndsrd-arrange-heading-regexp
  "\\(\\($B!TJF!U(B\\|$B!T1Q!U(B\\)?[][a-zA-Z0-9 !\".?/'(),<>$B!H!I(B-]\\)+[ \n]")

(defvar ndsrd-arrange-headings-list
  `(("<DR>\\|<ENVN?>" nil 1 nil)
    ("<PS>" nil 2 nil)
    ("<TQ>" "[IVX]+" 2 nil)
    ("<ID>" ,(concat "\\(\n.*\n\\)?" ndsrd-arrange-heading-regexp) 3 nil)
    ("<OT>" nil 3 nil)
    ("<TR>" "$B!Z(B[0-9]+$B![(B" 3 nil)
    ("<TRSUB>\\|<IDSUB>\\|<MNSUB>" "([0-9]+)" 4 nil)
    ("<IF>" nil 4 nil)
    ("<NBP?>" "$B"'(B" 4 nil)
    ("<OTSUB>" ,(concat "([0-9]+)\\|" ndsrd-arrange-heading-regexp
			"\\|\\[.*\\]$") 4 nil)
    ("<TL>\\|<J2E>" "$B!~(B?" 4 nil)
    ("<TLSUB>" "\\[.*\\]" 4 nil)
    ("<SRC>" nil 4 nil)
    ("<TLSUB>" ".*" 5 nil)
    ("<EX>" ,ndsrd-arrange-heading-regexp 5 nil)
    ("<NBP?SUB>" ,(concat "([0-9]+)\\|" ndsrd-arrange-heading-regexp
			  "\\|\\[.*\\]$") 5 nil)
    ("<SRCSUB>\\|<ET>" nil nil nil)
    ("<PR>" "\\[.*\\]" 2 t)
    )
  "(tag-regexp heading-regexp level delret)$B$rMWAG$H$9$k%j%9%H!#(B
tag-regexp$B$N(Bregexp$B$K%^%C%A$9$kItJ,$O:o$i$l!"0J9_$,(Bheading$B$N@hF,$K$J$k!#(B
tag-regexp$BFb$G$O(Bgrouping$B$O;H$($J$$!#(B
heading-regexp$B$K%^%C%A$9$kItJ,$K(Blevel(1-5)$B$N(Bface$B$,E,MQ$5$l$k!#(B
heading-regexp$B$,(Bnil$B$@$H%?%00J9_2~9T$^$G(Bmatch$B$9$k!#(B
face$B$N(Blevel$B$,(Bnil$B$@$H(Bface$B$OJQ99$5$l$J$$!#(B
delret$B$,(Bnon-nil$B$@$H%?%0$ND>A0$N2~9T$r>C5n$9$k!#(B")

(defconst ndsrd-arranges
  '(ndsrd-arrange-headings
    lookup-arrange-gaijis
    lookup-arrange-fill-lines))

(defconst ndsrd-adjusts
     '(lookup-adjust-show-gaijis
       lookup-adjust-goto-min))

(defconst ndsrd-gaiji-regexp "<\\(G[0-9]-[0-9a-f][0-9a-f]\\)>")

(defconst ndsrd-gaiji-directory (expand-file-name
				 "ndsrd-gaiji"
				 lookup-package-file-directory))

(put 'ndsrd 'gaiji 'ndsrd-dictionary-gaiji)
(defun ndsrd-dictionary-gaiji (dictionary code)
  (let ((file (expand-file-name
	       (concat (cadr (assoc code ndsrd-gaiji-xbm-table))
		       ".xbm")
	       ndsrd-gaiji-directory)))
    (when (file-readable-p file)
      (message "Reading file %s" file)
      (with-temp-buffer
	(insert-file-contents file)
	(buffer-string)))))

(defun ndsrd-arrange-headings (entry)
  "Lookup arrange function for ndsrd agent. This apply headings and left-margin."
  (re-search-forward "^$B""(B .*$" nil t)
  (lookup-make-region-heading (match-beginning 0) (match-end 0) 1)
  (narrow-to-region (match-end 0) (point-max))
  (let ((taglists ndsrd-arrange-headings-list))
    (while taglists
      (let* ((taglist (car taglists))
	     (regexp (concat "\\(\n*\\)\\( *\\)\\(" (car taglist)
			    "\\)\\(" (or (nth 1 taglist) ".*") "\\)"))
	     (level (nth 2 taglist)))
	(goto-char (point-min))
	(while (re-search-forward regexp nil t)
	  (when level
	    (lookup-make-region-heading
	     (match-beginning 4) (match-end 4) level))
	  (let ((lmargin (length (match-string 2))))
	    (delete-region (if (nth 3 taglist)
			       (match-beginning 1)
			     (match-beginning 2))
			   (match-end 3))
	    (unless (eq lmargin 0)
	      (set-left-margin (line-beginning-position) (line-end-position)
			       lmargin)))))
      (setq taglists (cdr taglists))))
  (widen))

(setq lookup-package-agent-options
      (list
       (cons ':arranges ndsrd-arranges)
       (cons ':adjusts ndsrd-adjusts)
       (cons ':gaiji-regexp ndsrd-gaiji-regexp)
       (cons ':headings '(lookup-arrange-gaijis))
       (cons ':fmt (expand-file-name "ndsrd.fmt"
				     lookup-package-file-directory))))

(setq lookup-package-dictionary-options-alist
      (list 
       (cons "srd"
	     (list
	      (cons ':gaiji-table ndsrd-gaiji-table)
	      ))))

;; ndsrd-pkg.el ends
